/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.gpio.base;

import io.silverspoon.bulldog.core.Edge;
import io.silverspoon.bulldog.core.Signal;
import io.silverspoon.bulldog.core.event.InterruptEventArgs;
import io.silverspoon.bulldog.core.event.InterruptListener;
import io.silverspoon.bulldog.core.gpio.DigitalInput;
import io.silverspoon.bulldog.core.pin.AbstractPinFeature;
import io.silverspoon.bulldog.core.pin.Pin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractDigitalInput
extends AbstractPinFeature
implements DigitalInput {
    private static final int MAX_DEBOUNCE_COUNT = 10;
    private static final String NAME_FORMAT = "Digital Input on Pin %s";
    private Edge trigger = Edge.Both;
    private List<InterruptListener> interruptListeners = Collections.synchronizedList(new ArrayList());
    private int debounceMs = 0;
    private boolean areInterruptsEnabled = true;

    public AbstractDigitalInput(Pin pin) {
        super(pin);
    }

    @Override
    public String getName() {
        return String.format(NAME_FORMAT, this.getPin().getName());
    }

    @Override
    public void setInterruptTrigger(Edge edge) {
        this.trigger = edge;
    }

    @Override
    public void setInterruptDebounceMs(int n) {
        this.debounceMs = n;
    }

    @Override
    public int getInterruptDebounceMs() {
        return this.debounceMs;
    }

    @Override
    public Edge getInterruptTrigger() {
        return this.trigger;
    }

    @Override
    public void addInterruptListener(InterruptListener interruptListener) {
        this.interruptListeners.add(interruptListener);
    }

    @Override
    public void removeInterruptListener(InterruptListener interruptListener) {
        this.interruptListeners.remove(interruptListener);
    }

    @Override
    public List<InterruptListener> getInterruptListeners() {
        return this.interruptListeners;
    }

    @Override
    public void clearInterruptListeners() {
        this.interruptListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireInterruptEvent(InterruptEventArgs interruptEventArgs) {
        List<InterruptListener> list = this.interruptListeners;
        synchronized (list) {
            if (!this.areInterruptsEnabled()) {
                return;
            }
            for (InterruptListener interruptListener : this.interruptListeners) {
                interruptListener.interruptRequest(interruptEventArgs);
            }
        }
    }

    @Override
    public Signal readDebounced(int n) {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        Signal signal = this.read();
        int n2 = 0;
        while (l2 < (long)n) {
            Signal signal2 = this.read();
            if (signal2 == signal && n2 > 0) {
                --n2;
            }
            if (signal2 != signal) {
                ++n2;
            }
            if (n2 >= 10) {
                n2 = 0;
                signal = signal2;
                return signal;
            }
            l2 = System.currentTimeMillis() - l;
        }
        return signal;
    }

    @Override
    public boolean areInterruptsEnabled() {
        return this.areInterruptsEnabled;
    }

    @Override
    public void enableInterrupts() {
        this.enableInterruptsImpl();
        this.areInterruptsEnabled = true;
    }

    @Override
    public void disableInterrupts() {
        this.disableInterruptsImpl();
        this.areInterruptsEnabled = false;
    }

    protected abstract void enableInterruptsImpl();

    protected abstract void disableInterruptsImpl();
}

