/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.pwm;

import io.silverspoon.bulldog.core.Signal;
import io.silverspoon.bulldog.core.gpio.DigitalOutput;
import io.silverspoon.bulldog.core.pin.Pin;
import io.silverspoon.bulldog.core.pwm.AbstractPwm;
import io.silverspoon.bulldog.core.util.BulldogUtil;
import io.silverspoon.bulldog.core.util.DaemonThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class SoftPwm
extends AbstractPwm
implements Runnable {
    private static final long NANOSECONDS_PER_SECOND = 1000000000L;
    private ScheduledExecutorService executorService;
    private DigitalOutput output;
    private int dutyInNanoseconds;
    private int periodInNanoseconds;
    private ScheduledFuture<?> future;

    public SoftPwm(Pin pin) {
        super(pin);
        if (!pin.hasFeature(DigitalOutput.class)) {
            throw new IllegalArgumentException("The pin must be able to act as a DigitalOutput");
        }
        this.output = pin.getFeature(DigitalOutput.class);
        pin.getFeatures().add(this);
    }

    public SoftPwm(DigitalOutput digitalOutput) {
        this(digitalOutput.getPin());
    }

    private void createScheduler() {
        if (this.executorService != null) {
            return;
        }
        this.executorService = Executors.newScheduledThreadPool(1, new DaemonThreadFactory());
        this.future = this.executorService.scheduleAtFixedRate(this, 0L, this.periodInNanoseconds, TimeUnit.NANOSECONDS);
    }

    private void terminateScheduler() {
        if (this.executorService == null) {
            return;
        }
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(1000L, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.executorService = null;
    }

    @Override
    public void run() {
        this.output.applySignal(Signal.High);
        BulldogUtil.sleepNs(this.dutyInNanoseconds);
        this.output.applySignal(Signal.Low);
    }

    @Override
    public void setupImpl() {
        this.output.setup();
    }

    @Override
    public void teardownImpl() {
        this.terminateScheduler();
        this.output.teardown();
    }

    @Override
    protected void setPwmImpl(double d, double d2) {
        this.periodInNanoseconds = (int)(1.0 / d * 1.0E9);
        this.dutyInNanoseconds = (int)((double)this.periodInNanoseconds * d2);
    }

    @Override
    protected void enableImpl() {
        if (!this.isActivatedFeature()) {
            this.activate();
        }
        this.blockPin();
        this.createScheduler();
    }

    @Override
    protected void disableImpl() {
        this.terminateScheduler();
        this.unblockPin();
    }
}

