/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.pwm;

import io.silverspoon.bulldog.core.event.ThresholdListener;
import io.silverspoon.bulldog.core.pin.AbstractPinFeature;
import io.silverspoon.bulldog.core.pin.Pin;
import io.silverspoon.bulldog.core.pwm.AnalogInput;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractAnalogInput
extends AbstractPinFeature
implements AnalogInput {
    private static final String NAME_FORMAT = "Analog Input on Pin %s";
    private ScheduledFuture<?> future;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public AbstractAnalogInput(Pin pin) {
        super(pin);
    }

    @Override
    public String getName() {
        return String.format(NAME_FORMAT, this.getPin().getName());
    }

    @Override
    public void startMonitor(int n, final ThresholdListener thresholdListener) {
        if (thresholdListener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.blockPin();
        this.future = this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                double[] dArray = AbstractAnalogInput.this.sample(10);
                for (int i = 0; i < dArray.length; ++i) {
                    if (!thresholdListener.isThresholdReached(dArray[i])) continue;
                    thresholdListener.thresholdReached();
                }
            }
        }, 0L, n, TimeUnit.MICROSECONDS);
    }

    @Override
    public void stopMonitor() {
        if (this.future == null) {
            return;
        }
        this.future.cancel(true);
        this.unblockPin();
    }
}

