/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.platform;

import io.silverspoon.bulldog.core.io.IOPort;
import io.silverspoon.bulldog.core.io.bus.i2c.I2cBus;
import io.silverspoon.bulldog.core.io.bus.spi.SpiBus;
import io.silverspoon.bulldog.core.io.serial.SerialPort;
import io.silverspoon.bulldog.core.pin.Pin;
import io.silverspoon.bulldog.core.platform.AbstractPinProvider;
import io.silverspoon.bulldog.core.platform.Board;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractBoard
extends AbstractPinProvider
implements Board {
    private List<I2cBus> i2cBuses = new ArrayList<I2cBus>();
    private List<SpiBus> spiBuses = new ArrayList<SpiBus>();
    private List<SerialPort> serialBuses = new ArrayList<SerialPort>();
    private Properties properties = new Properties();

    public AbstractBoard() {
        this.createShutdownHook();
    }

    @Override
    public IOPort getIOPortByAlias(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null may not be passed as an alias name for an IOPort.");
        }
        for (IOPort iOPort : this.getAllIOPorts()) {
            if (!string.equals(iOPort.getAlias())) continue;
            return iOPort;
        }
        return null;
    }

    @Override
    public IOPort getIOPortByName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null may not be passed as a name for an IOPort.");
        }
        for (IOPort iOPort : this.getAllIOPorts()) {
            if (!string.equals(iOPort.getName())) continue;
            return iOPort;
        }
        return null;
    }

    @Override
    public List<IOPort> getAllIOPorts() {
        ArrayList<IOPort> arrayList = new ArrayList<IOPort>();
        arrayList.addAll(this.getI2cBuses());
        arrayList.addAll(this.getSerialPorts());
        arrayList.addAll(this.getSpiBuses());
        return arrayList;
    }

    @Override
    public List<I2cBus> getI2cBuses() {
        return this.i2cBuses;
    }

    @Override
    public List<SerialPort> getSerialPorts() {
        return this.serialBuses;
    }

    @Override
    public List<SpiBus> getSpiBuses() {
        return this.spiBuses;
    }

    @Override
    public SpiBus getSpiBus(String string) {
        return (SpiBus)this.getIOPortByName(string);
    }

    @Override
    public SerialPort getSerialPort(String string) {
        return (SerialPort)this.getIOPortByName(string);
    }

    @Override
    public I2cBus getI2cBus(String string) {
        return (I2cBus)this.getIOPortByName(string);
    }

    @Override
    public boolean hasProperty(String string) {
        return this.properties.containsKey(string);
    }

    @Override
    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    @Override
    public abstract String getName();

    @Override
    public void shutdown() {
        this.cleanup();
    }

    public void cleanup() {
        for (Pin pin : this.getPins()) {
            if (pin.getActiveFeature() == null || !pin.getActiveFeature().isTorndownOnShutdown()) continue;
            pin.getActiveFeature().teardown();
        }
    }

    public void createShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AbstractBoard.this.cleanup();
            }
        });
    }
}

