/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.pin;

import io.silverspoon.bulldog.core.event.FeatureActivationEventArgs;
import io.silverspoon.bulldog.core.event.FeatureActivationListener;
import io.silverspoon.bulldog.core.pin.PinBlockedException;
import io.silverspoon.bulldog.core.pin.PinFeature;
import java.util.ArrayList;
import java.util.List;

public class Pin {
    private List<PinFeature> features = new ArrayList<PinFeature>();
    private int address = 0;
    private String name = null;
    private String alias = null;
    private String port = null;
    private int indexOnPort = 0;
    private PinFeature activeFeature = null;
    private PinFeature blocker = null;
    private List<FeatureActivationListener> activationListeners = new ArrayList<FeatureActivationListener>();

    public Pin(String string, int n, String string2, int n2) {
        this.name = string;
        this.address = n;
        this.port = string2;
        this.indexOnPort = n2;
    }

    public <T extends PinFeature> void activateFeature(Class<T> clazz) {
        this.checkIfDesiredFeatureIsAvailable(clazz);
        T t = this.getFeature(clazz);
        this.activateFeature((PinFeature)t);
    }

    public Pin addFeature(PinFeature pinFeature) {
        for (PinFeature pinFeature2 : this.getFeatures()) {
            if (!pinFeature2.getClass().equals(pinFeature.getClass())) continue;
            throw new IllegalArgumentException("This pin already posseses the feature you are trying to add!");
        }
        this.getFeatures().add(pinFeature);
        return this;
    }

    public Pin removeFeature(Class<? extends PinFeature> clazz) {
        PinFeature pinFeature = null;
        for (PinFeature pinFeature2 : this.getFeatures()) {
            if (!pinFeature2.getClass().equals(clazz)) continue;
            pinFeature = pinFeature2;
            break;
        }
        if (pinFeature != null) {
            pinFeature.teardown();
            if (pinFeature == this.getActiveFeature()) {
                this.setActiveFeature(null);
            }
            this.getFeatures().remove(pinFeature);
        }
        return this;
    }

    public <T extends PinFeature> T as(Class<T> clazz) {
        this.checkIfDesiredFeatureIsAvailable(clazz);
        T t = this.getFeature(clazz);
        this.activateFeature((PinFeature)t);
        return t;
    }

    public void block(PinFeature pinFeature) {
        if (this.getBlocker() != null && this.getBlocker() != pinFeature) {
            throw new PinBlockedException(this.getBlocker());
        }
        this.blocker = pinFeature;
    }

    public void unblock(PinFeature pinFeature) {
        if (this.getBlocker() != null && this.getBlocker() != pinFeature) {
            throw new PinBlockedException(this.getBlocker());
        }
        this.blocker = null;
    }

    public PinFeature getBlocker() {
        return this.blocker;
    }

    public boolean isBlocked() {
        return this.blocker != null;
    }

    public <T extends PinFeature> T getFeature(Class<T> clazz) {
        PinFeature pinFeature = null;
        for (PinFeature pinFeature2 : this.getFeatures()) {
            if (pinFeature2.getClass().equals(clazz)) {
                pinFeature = pinFeature2;
                break;
            }
            if (pinFeature != null || !clazz.isAssignableFrom(pinFeature2.getClass())) continue;
            pinFeature = pinFeature2;
        }
        return (T)pinFeature;
    }

    public PinFeature getActiveFeature() {
        return this.activeFeature;
    }

    public boolean isFeatureActive(Class<? extends PinFeature> clazz) {
        if (this.getActiveFeature() == null) {
            return false;
        }
        return clazz.isAssignableFrom(this.getActiveFeature().getClass());
    }

    public boolean isFeatureActive(PinFeature pinFeature) {
        return this.getActiveFeature() == pinFeature;
    }

    public int getAddress() {
        return this.address;
    }

    public String getPort() {
        return this.port;
    }

    public int getIndexOnPort() {
        return this.indexOnPort;
    }

    public List<PinFeature> getFeatures() {
        return this.features;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public boolean hasFeature(Class<? extends PinFeature> clazz) {
        for (PinFeature pinFeature : this.getFeatures()) {
            if (!clazz.isAssignableFrom(pinFeature.getClass())) continue;
            return true;
        }
        return false;
    }

    private void setActiveFeature(PinFeature pinFeature) {
        this.activeFeature = pinFeature;
    }

    private void activateFeature(PinFeature pinFeature) {
        if (pinFeature == this.getActiveFeature()) {
            return;
        }
        PinFeature pinFeature2 = this.getBlocker();
        if (pinFeature2 != null) {
            throw new PinBlockedException(pinFeature2);
        }
        if (this.getActiveFeature() != null) {
            this.deactivateFeature(this.getActiveFeature());
        }
        this.fireFeatureActivating(pinFeature);
        if (!pinFeature.isSetup()) {
            pinFeature.setup();
        }
        this.setActiveFeature(pinFeature);
        this.fireFeatureActivated(pinFeature);
    }

    private void deactivateFeature(PinFeature pinFeature) {
        this.fireFeatureDeactivating(pinFeature);
        pinFeature.teardown();
        this.setActiveFeature(null);
        this.fireFeatureDeactivated(pinFeature);
    }

    private <T extends PinFeature> void checkIfDesiredFeatureIsAvailable(Class<T> clazz) {
        if (!this.hasFeature(clazz)) {
            throw new IllegalArgumentException("This pin does not possess the desired feature");
        }
    }

    public void addFeatureActivationListener(FeatureActivationListener featureActivationListener) {
        this.activationListeners.add(featureActivationListener);
    }

    public void removeFeatureActivationListener(FeatureActivationListener featureActivationListener) {
        this.activationListeners.remove(featureActivationListener);
    }

    public void clearFeatureActivationListeners() {
        this.activationListeners.clear();
    }

    public List<FeatureActivationListener> getFeatureActivationListeners() {
        return this.activationListeners;
    }

    protected void fireFeatureActivating(PinFeature pinFeature) {
        for (FeatureActivationListener featureActivationListener : this.activationListeners) {
            featureActivationListener.featureActivating(this, new FeatureActivationEventArgs(pinFeature));
        }
    }

    protected void fireFeatureActivated(PinFeature pinFeature) {
        for (FeatureActivationListener featureActivationListener : this.activationListeners) {
            featureActivationListener.featureActivated(this, new FeatureActivationEventArgs(pinFeature));
        }
    }

    protected void fireFeatureDeactivating(PinFeature pinFeature) {
        for (FeatureActivationListener featureActivationListener : this.activationListeners) {
            featureActivationListener.featureDeactivating(this, new FeatureActivationEventArgs(pinFeature));
        }
    }

    protected void fireFeatureDeactivated(PinFeature pinFeature) {
        for (FeatureActivationListener featureActivationListener : this.activationListeners) {
            featureActivationListener.featureDeactivated(this, new FeatureActivationEventArgs(pinFeature));
        }
    }
}

