/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.io.bus;

import io.silverspoon.bulldog.core.io.bus.Bus;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BusConnection {
    private int address;
    private Bus bus;

    public BusConnection(Bus bus, int n) {
        this.bus = bus;
        this.address = n;
    }

    public Bus getBus() {
        return this.bus;
    }

    public int getAddress() {
        return this.address;
    }

    public void writeByte(int n) throws IOException {
        this.acquireBus();
        this.bus.writeByte(n);
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.acquireBus();
        this.bus.writeBytes(byArray);
    }

    public void writeString(String string) throws IOException {
        this.acquireBus();
        this.bus.writeString(string);
    }

    public byte readByte() throws IOException {
        this.acquireBus();
        return this.bus.readByte();
    }

    public int readBytes(byte[] byArray) throws IOException {
        this.acquireBus();
        return this.bus.readBytes(byArray);
    }

    public String readString() throws IOException {
        this.acquireBus();
        return this.bus.readString();
    }

    protected void acquireBus() throws IOException {
        if (!this.getBus().isOpen()) {
            this.getBus().open();
        }
        if (!this.getBus().isSlaveSelected(this.address)) {
            this.getBus().selectSlave(this.address);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        this.acquireBus();
        return this.bus.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        this.acquireBus();
        return this.bus.getInputStream();
    }
}

