/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.io;

import io.silverspoon.bulldog.core.Signal;
import io.silverspoon.bulldog.core.gpio.DigitalIO;
import io.silverspoon.bulldog.core.io.PinIOGroup;
import io.silverspoon.bulldog.core.util.BitMagic;
import java.io.IOException;
import java.io.OutputStream;

public class PinIOOutputStream
extends OutputStream {
    private PinIOGroup group;

    public PinIOOutputStream(PinIOGroup pinIOGroup) {
        this.group = pinIOGroup;
    }

    @Override
    public void write(int n) throws IOException {
        this.group.startEnable();
        for (int i = 0; i < this.group.getDataPins().length; ++i) {
            DigitalIO digitalIO = this.group.getDataPins()[i];
            Signal signal = Signal.fromNumericValue(BitMagic.getBit(n, i));
            digitalIO.applySignal(signal);
        }
        this.group.endEnable();
    }
}

