/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.io;

import io.silverspoon.bulldog.core.Signal;
import io.silverspoon.bulldog.core.gpio.DigitalIO;
import io.silverspoon.bulldog.core.io.IOPort;
import io.silverspoon.bulldog.core.io.PinIOInputStream;
import io.silverspoon.bulldog.core.io.PinIOOutputStream;
import io.silverspoon.bulldog.core.util.BulldogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PinIOGroup
implements IOPort {
    private DigitalIO[] dataPins;
    private DigitalIO enablePin;
    private PinIOInputStream inputStream;
    private PinIOOutputStream outputStream;
    private String alias;
    private String name;
    private int delayMs = 1;

    public PinIOGroup(DigitalIO digitalIO, DigitalIO ... digitalIOArray) {
        this(digitalIO, 1, digitalIOArray);
    }

    public PinIOGroup(DigitalIO digitalIO, int n, DigitalIO ... digitalIOArray) {
        this.enablePin = digitalIO;
        this.dataPins = digitalIOArray;
        this.delayMs = n;
        this.inputStream = new PinIOInputStream(this);
        this.outputStream = new PinIOOutputStream(this);
        this.name = this.buildName();
    }

    private String buildName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PinIOGroup: \n");
        stringBuilder.append("[Enable] " + this.enablePin.getName() + "\n");
        for (int i = 0; i < this.dataPins.length; ++i) {
            stringBuilder.append("[Data " + i + "] " + this.dataPins[i].getName() + "\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String string) {
        this.alias = string;
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.getOutputStream().write(n);
    }

    @Override
    public void writeBytes(byte[] byArray) throws IOException {
        this.getOutputStream().write(byArray);
    }

    @Override
    public void writeString(String string) throws IOException {
        this.writeBytes(string.getBytes());
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.getInputStream().read();
    }

    @Override
    public int readBytes(byte[] byArray) throws IOException {
        return this.getInputStream().read(byArray);
    }

    @Override
    public String readString() throws IOException {
        return BulldogUtil.convertStreamToString(this.getInputStream());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public DigitalIO[] getDataPins() {
        return this.dataPins;
    }

    public void startEnable() {
        this.enablePin.applySignal(Signal.High);
        BulldogUtil.sleepMs(this.delayMs);
    }

    public void endEnable() {
        this.enablePin.applySignal(Signal.Low);
        BulldogUtil.sleepMs(this.delayMs);
    }

    public String toString() {
        return this.getName();
    }
}

