/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.util;

public final class BitMagic {
    private static final String ERROR_INVALID_VALUE = "A bit can only be set to either 0 or 1";
    private static final String ERROR_INVALID_BIT_POSITION = "There are only %d bits (bit 0 to %d) in this type. Invalid bit position";

    public static int getBit(byte by, int n) {
        BitMagic.checkPosition(n, 8);
        return by >> n & 1;
    }

    public static int getBit(short s, int n) {
        BitMagic.checkPosition(n, 16);
        return s >> n & 1;
    }

    public static int getBit(int n, int n2) {
        BitMagic.checkPosition(n2, 32);
        return n >> n2 & 1;
    }

    public static int getBit(long l, int n) {
        BitMagic.checkPosition(n, 64);
        return (int)(l >> n) & 1;
    }

    public static byte setBit(byte by, int n, int n2) {
        BitMagic.checkValue(n2);
        BitMagic.checkPosition(n, 8);
        by = n2 == 1 ? (byte)(by | n2 << n) : (byte)(by & ~(1 << n));
        return by;
    }

    public static short setBit(short s, int n, int n2) {
        BitMagic.checkValue(n2);
        BitMagic.checkPosition(n, 16);
        s = n2 == 1 ? (short)(s | n2 << n) : (short)(s & ~(1 << n));
        return s;
    }

    public static int setBit(int n, int n2, int n3) {
        BitMagic.checkValue(n3);
        BitMagic.checkPosition(n2, 32);
        n = n3 == 1 ? (n |= n3 << n2) : (n &= ~(1 << n2));
        return n;
    }

    public static long setBit(long l, int n, int n2) {
        BitMagic.checkValue(n2);
        BitMagic.checkPosition(n, 64);
        l = n2 == 1 ? (l |= (long)(n2 << n)) : (l &= (long)(~(1 << n)));
        return l;
    }

    public static boolean isBitSet(byte by, int n) {
        BitMagic.checkPosition(n, 8);
        return (by & 1 << n) != 0;
    }

    public static boolean isBitSet(short s, int n) {
        BitMagic.checkPosition(n, 16);
        return (s & 1 << n) != 0;
    }

    public static boolean isBitSet(int n, int n2) {
        BitMagic.checkPosition(n2, 32);
        return (n & 1 << n2) != 0;
    }

    public static boolean isBitSet(long l, int n) {
        BitMagic.checkPosition(n, 64);
        return (l & (long)(1 << n)) != 0L;
    }

    public static byte toggleBit(byte by, int n) {
        BitMagic.checkPosition(n, 8);
        by = (byte)(by ^ 1 << n);
        return by;
    }

    public static short toggleBit(short s, int n) {
        BitMagic.checkPosition(n, 16);
        s = (short)(s ^ 1 << n);
        return s;
    }

    public static int toggleBit(int n, int n2) {
        BitMagic.checkPosition(n2, 32);
        return n ^= 1 << n2;
    }

    public static long toggleBit(long l, int n) {
        BitMagic.checkPosition(n, 64);
        return l ^= (long)(1 << n);
    }

    public static String toBitString(byte by) {
        String string = String.format("0b%8s", Integer.toBinaryString(by & 0xFF)).replace(' ', '0');
        return string;
    }

    public static String toBitString(short s) {
        String string = String.format("0b%16s", Integer.toBinaryString(s & 0xFFFF)).replace(' ', '0');
        return string;
    }

    public static String toBitString(int n) {
        String string = String.format("0b%32s", Integer.toBinaryString(n)).replace(' ', '0');
        return string;
    }

    public static String toBitString(long l) {
        String string = String.format("0b%64s", Long.toBinaryString(l & 0xFFFFFFFFFFFFFFFFL)).replace(' ', '0');
        return string;
    }

    public static byte getLowerNibble(byte by) {
        return (byte)(by & 0xF);
    }

    public static byte getUpperNibble(byte by) {
        return (byte)((by & 0xF0) >> 4);
    }

    public static byte byteFromNibbles(int n, int n2) {
        return BitMagic.byteFromNibbles((byte)n, (byte)n2);
    }

    public static byte byteFromNibbles(byte by, byte by2) {
        return (byte)(by << 4 | by2);
    }

    public static byte reverse(byte by) {
        by = (byte)((by & 0xF0) >> 4 | (by & 0xF) << 4);
        by = (byte)((by & 0xCC) >> 2 | (by & 0x33) << 2);
        by = (byte)((by & 0xAA) >> 1 | (by & 0x55) << 1);
        return by;
    }

    private static void checkValue(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(ERROR_INVALID_VALUE);
        }
    }

    private static void checkPosition(int n, int n2) {
        if (n > n2 - 1 || n < 0) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_BIT_POSITION, n2, n2 - 1));
        }
    }
}

