/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.io.bus.spi;

import io.silverspoon.bulldog.core.gpio.DigitalOutput;
import io.silverspoon.bulldog.core.io.bus.BusConnection;
import io.silverspoon.bulldog.core.io.bus.spi.SpiBus;
import io.silverspoon.bulldog.core.io.bus.spi.SpiMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SpiConnection
extends BusConnection {
    private List<Integer> chipSelectList = new ArrayList<Integer>();

    public SpiConnection(SpiBus spiBus, int n) {
        super(spiBus, n);
        this.chipSelectList.add(n);
    }

    public SpiConnection(SpiBus spiBus, DigitalOutput ... digitalOutputArray) {
        super(spiBus, 0);
        for (DigitalOutput digitalOutput : digitalOutputArray) {
            this.chipSelectList.add(digitalOutput.getPin().getAddress());
        }
    }

    public SpiConnection(SpiBus spiBus, int ... nArray) {
        super(spiBus, 0);
        int[] nArray2 = nArray;
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray2[i];
            this.chipSelectList.add(n2);
        }
    }

    public SpiConnection(SpiBus spiBus) {
        super(spiBus, 0);
    }

    @Override
    protected void acquireBus() throws IOException {
        if (!this.getBus().isOpen()) {
            this.getBus().open();
        }
        if (this.chipSelectList.size() > 0) {
            this.getBus().selectSlaves(this.chipSelectList.toArray(new Integer[this.chipSelectList.size()]));
        }
    }

    public SpiMessage transfer(byte[] byArray) throws IOException {
        this.acquireBus();
        SpiMessage spiMessage = this.getBus().transfer(byArray);
        return spiMessage;
    }

    @Override
    public SpiBus getBus() {
        return (SpiBus)super.getBus();
    }
}

