/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.gpio.util;

import io.silverspoon.bulldog.core.gpio.Pwm;
import io.silverspoon.bulldog.core.util.easing.Easing;
import io.silverspoon.bulldog.core.util.easing.EasingOptions;

public class PwmController {
    public void dutyTransition(Pwm pwm, double d, int n, Easing easing, EasingOptions easingOptions) {
        long l = System.currentTimeMillis();
        double d2 = pwm.getDuty();
        double d3 = Math.abs(d2 - d);
        long l2 = 0L;
        while (l2 < (long)n) {
            double d4;
            l2 = System.currentTimeMillis() - l;
            double d5 = d3 * (double)easingOptions.calculate(easing, l2, n);
            if (d2 < d) {
                d4 = d2 + d5;
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                pwm.setDuty(d4);
                continue;
            }
            d4 = d2 - d5;
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            pwm.setDuty(d4);
        }
    }

    public void frequencyTransition(Pwm pwm, double d, int n, Easing easing, EasingOptions easingOptions) {
        long l = System.currentTimeMillis();
        double d2 = pwm.getFrequency();
        double d3 = Math.abs(d2 - d);
        long l2 = 0L;
        while (l2 < (long)n) {
            l2 = System.currentTimeMillis() - l;
            double d4 = d3 * (double)easingOptions.calculate(easing, l2, n);
            if (d2 < d) {
                pwm.setDuty(d2 + d4);
                continue;
            }
            pwm.setDuty(d2 - d4);
        }
    }
}

