/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.gpio.base;

import io.silverspoon.bulldog.core.Edge;
import io.silverspoon.bulldog.core.Signal;
import io.silverspoon.bulldog.core.gpio.DigitalIO;
import io.silverspoon.bulldog.core.gpio.DigitalInput;
import io.silverspoon.bulldog.core.gpio.DigitalOutput;
import io.silverspoon.bulldog.core.gpio.Pin;
import io.silverspoon.bulldog.core.gpio.base.AbstractPinFeature;
import io.silverspoon.bulldog.core.gpio.event.InterruptEventArgs;
import io.silverspoon.bulldog.core.gpio.event.InterruptListener;
import java.util.List;

public class DigitalIOFeature
extends AbstractPinFeature
implements DigitalIO {
    private static final String NAME_FORMAT = "Digital IO on Pin %s";
    private DigitalOutput output;
    private DigitalInput input;

    public DigitalIOFeature(Pin pin, DigitalInput digitalInput, DigitalOutput digitalOutput) {
        super(pin);
        this.output = digitalOutput;
        this.input = digitalInput;
    }

    @Override
    public Signal read() {
        this.setupInputIfNecessary();
        return this.input.read();
    }

    private void setupInputIfNecessary() {
        if (!this.input.isSetup()) {
            if (this.output.isSetup()) {
                this.output.teardown();
            }
            this.input.setup();
        }
    }

    private void setupOutputIfNecessary() {
        if (!this.output.isSetup()) {
            if (this.input.isSetup()) {
                this.input.teardown();
            }
            this.output.setup();
        }
    }

    @Override
    public Signal readDebounced(int n) {
        this.setupInputIfNecessary();
        return this.input.readDebounced(n);
    }

    @Override
    public void disableInterrupts() {
        this.setupInputIfNecessary();
        this.input.disableInterrupts();
    }

    @Override
    public void enableInterrupts() {
        this.setupInputIfNecessary();
        this.input.enableInterrupts();
    }

    @Override
    public boolean areInterruptsEnabled() {
        this.setupInputIfNecessary();
        return this.input.areInterruptsEnabled();
    }

    @Override
    public void setInterruptDebounceMs(int n) {
        this.setupInputIfNecessary();
        this.input.setInterruptDebounceMs(n);
    }

    @Override
    public int getInterruptDebounceMs() {
        this.setupInputIfNecessary();
        return this.input.getInterruptDebounceMs();
    }

    @Override
    public void setInterruptTrigger(Edge edge) {
        this.setupInputIfNecessary();
        this.input.setInterruptTrigger(edge);
    }

    @Override
    public Edge getInterruptTrigger() {
        this.setupInputIfNecessary();
        return this.input.getInterruptTrigger();
    }

    @Override
    public void fireInterruptEvent(InterruptEventArgs interruptEventArgs) {
        this.setupInputIfNecessary();
        this.input.fireInterruptEvent(interruptEventArgs);
    }

    @Override
    public void addInterruptListener(InterruptListener interruptListener) {
        this.setupInputIfNecessary();
        this.input.addInterruptListener(interruptListener);
    }

    @Override
    public void removeInterruptListener(InterruptListener interruptListener) {
        this.setupInputIfNecessary();
        this.input.removeInterruptListener(interruptListener);
    }

    @Override
    public void clearInterruptListeners() {
        this.setupInputIfNecessary();
        this.input.clearInterruptListeners();
    }

    @Override
    public List<InterruptListener> getInterruptListeners() {
        this.setupInputIfNecessary();
        return this.input.getInterruptListeners();
    }

    @Override
    public String getName() {
        return String.format(NAME_FORMAT, this.getPin().getName());
    }

    @Override
    public void write(Signal signal) {
        this.setupOutputIfNecessary();
        this.output.write(signal);
    }

    @Override
    public void applySignal(Signal signal) {
        this.setupOutputIfNecessary();
        this.output.applySignal(signal);
    }

    @Override
    public Signal getAppliedSignal() {
        this.setupOutputIfNecessary();
        return this.output.getAppliedSignal();
    }

    @Override
    public void high() {
        this.setupOutputIfNecessary();
        this.output.high();
    }

    @Override
    public void low() {
        this.setupOutputIfNecessary();
        this.output.low();
    }

    @Override
    public void toggle() {
        this.setupOutputIfNecessary();
        this.output.toggle();
    }

    @Override
    public boolean isHigh() {
        this.setupOutputIfNecessary();
        return this.output.isHigh();
    }

    @Override
    public boolean isLow() {
        this.setupOutputIfNecessary();
        return this.output.isLow();
    }

    @Override
    public void startBlinking(int n) {
        this.setupOutputIfNecessary();
        this.output.startBlinking(n);
    }

    @Override
    public void startBlinking(int n, int n2) {
        this.setupOutputIfNecessary();
        this.output.startBlinking(n, n2);
    }

    @Override
    public void blinkTimes(int n, int n2) {
        this.setupOutputIfNecessary();
        this.output.blinkTimes(n, n2);
    }

    @Override
    public void stopBlinking() {
        this.setupOutputIfNecessary();
        this.output.stopBlinking();
    }

    @Override
    public boolean isBlinking() {
        this.setupOutputIfNecessary();
        return this.output.isBlinking();
    }

    @Override
    public void awaitBlinkingStopped() {
        this.setupOutputIfNecessary();
        this.output.awaitBlinkingStopped();
    }

    @Override
    protected void setupImpl() {
    }

    @Override
    protected void teardownImpl() {
        if (this.isInputActive()) {
            this.input.teardown();
        } else if (this.isOutputActive()) {
            this.output.teardown();
        }
    }

    @Override
    public boolean isBlocking() {
        return this.getPin().getBlocker() == this || this.getPin().getBlocker() == this.output || this.getPin().getBlocker() == this.input;
    }

    @Override
    public boolean isInputActive() {
        return this.input.isSetup();
    }

    @Override
    public boolean isOutputActive() {
        return this.output.isSetup();
    }
}

