/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.gpio.base;

import io.silverspoon.bulldog.core.gpio.Pin;
import io.silverspoon.bulldog.core.gpio.Pwm;
import io.silverspoon.bulldog.core.gpio.base.AbstractPinFeature;

public abstract class AbstractPwm
extends AbstractPinFeature
implements Pwm {
    private String NAME_FORMAT = "PWM - status '%s' - frequency '%.2f' with duty '%.2f' on Pin %s";
    private double duty = 0.0;
    private double frequency = 1.0;
    private boolean enabled = false;

    public AbstractPwm(Pin pin) {
        super(pin);
    }

    @Override
    public String getName() {
        return String.format(this.NAME_FORMAT, this.isEnabled() ? "enabled" : "disabled", this.getFrequency(), this.getDuty(), this.getPin().getName());
    }

    @Override
    public void enable() {
        this.enableImpl();
        this.enabled = true;
    }

    @Override
    public void disable() {
        this.disableImpl();
        this.enabled = false;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setDuty(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Duty cannot be less than 0.0 or greater 1.0; Specified value: " + d);
        }
        this.duty = d;
        this.setPwmImpl(this.getFrequency(), d);
    }

    @Override
    public double getDuty() {
        return this.duty;
    }

    @Override
    public void setFrequency(double d) {
        if (d < 1.0) {
            throw new IllegalArgumentException("Frequency cannot be less than 1.0 Hz; Specified value: " + d);
        }
        this.frequency = d;
        this.setPwmImpl(d, this.getDuty());
    }

    @Override
    public double getFrequency() {
        return this.frequency;
    }

    protected abstract void setPwmImpl(double var1, double var3);

    protected abstract void enableImpl();

    protected abstract void disableImpl();
}

