/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.gpio.base;

import io.silverspoon.bulldog.core.gpio.Pin;
import io.silverspoon.bulldog.core.gpio.PinFeature;

public abstract class AbstractPinFeature
implements PinFeature {
    private Pin pin;
    private boolean isSetup = false;
    private boolean teardownOnShutdown = false;

    public AbstractPinFeature(Pin pin) {
        this.pin = pin;
    }

    @Override
    public Pin getPin() {
        return this.pin;
    }

    @Override
    public boolean isActivatedFeature() {
        return this.getPin().getActiveFeature() == this;
    }

    @Override
    public void activate() {
        this.getPin().activateFeature(this.getClass());
    }

    @Override
    public void blockPin() {
        this.pin.block(this);
    }

    @Override
    public boolean isBlocking() {
        return this.pin.getBlocker() == this;
    }

    @Override
    public void unblockPin() {
        this.getPin().unblock(this);
    }

    protected abstract void setupImpl();

    protected abstract void teardownImpl();

    @Override
    public void setup() {
        this.setupImpl();
        this.isSetup = true;
    }

    @Override
    public void teardown() {
        this.teardownImpl();
        this.isSetup = false;
    }

    @Override
    public boolean isSetup() {
        return this.isSetup;
    }

    @Override
    public boolean isTorndownOnShutdown() {
        return this.teardownOnShutdown;
    }

    @Override
    public void setTeardownOnShutdown(boolean bl) {
        this.teardownOnShutdown = bl;
    }

    public String toString() {
        String string = this.getName();
        if (string == null) {
            string = super.toString();
        }
        return string;
    }
}

