/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.gpio.base;

import io.silverspoon.bulldog.core.Signal;
import io.silverspoon.bulldog.core.gpio.DigitalOutput;
import io.silverspoon.bulldog.core.gpio.Pin;
import io.silverspoon.bulldog.core.gpio.base.AbstractPinFeature;
import io.silverspoon.bulldog.core.gpio.util.Blinker;

public abstract class AbstractDigitalOutput
extends AbstractPinFeature
implements DigitalOutput {
    private static final String NAME_FORMAT = "Digital Output - Signal '%s' on Pin %s";
    private Signal signal = Signal.Low;
    private Blinker blinker = new Blinker(this);

    public AbstractDigitalOutput(Pin pin) {
        super(pin);
    }

    @Override
    public String getName() {
        return String.format(NAME_FORMAT, new Object[]{this.signal, this.getPin().getName()});
    }

    @Override
    public void write(Signal signal) {
        this.applySignal(signal);
    }

    @Override
    public void applySignal(Signal signal) {
        this.signal = signal;
        this.applySignalImpl(this.signal);
    }

    @Override
    public void high() {
        this.applySignal(Signal.High);
    }

    @Override
    public void low() {
        this.applySignal(Signal.Low);
    }

    @Override
    public boolean isHigh() {
        return this.signal == Signal.High;
    }

    @Override
    public boolean isLow() {
        return this.signal == Signal.Low;
    }

    @Override
    public void toggle() {
        this.applySignal(this.signal.inverse());
    }

    @Override
    public Signal getAppliedSignal() {
        return this.signal;
    }

    @Override
    public void startBlinking(int n) {
        this.blinker.startBlinking(n);
    }

    @Override
    public void startBlinking(int n, int n2) {
        this.blinker.startBlinking(n, n2);
    }

    @Override
    public void stopBlinking() {
        this.blinker.stopBlinking();
    }

    @Override
    public void blinkTimes(int n, int n2) {
        this.blinker.blinkTimes(n, n2);
    }

    @Override
    public boolean isBlinking() {
        return this.blinker.isBlinking();
    }

    @Override
    public void awaitBlinkingStopped() {
        this.blinker.awaitBlinkingStopped();
    }

    protected abstract void applySignalImpl(Signal var1);
}

