/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core;

import io.silverspoon.bulldog.core.util.BulldogUtil;

public enum Signal {
    High(1, true),
    Low(0, false);

    private int numericValue;
    private boolean booleanValue;

    private Signal(int n2, boolean bl) {
        this.numericValue = n2;
        this.booleanValue = bl;
    }

    public int getNumericValue() {
        return this.numericValue;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public static Signal fromNumericValue(int n) {
        if (n == 0) {
            return Low;
        }
        return High;
    }

    public static Signal fromBooleanValue(boolean bl) {
        if (bl) {
            return High;
        }
        return Low;
    }

    public static Signal fromString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("value cannot be null!");
        }
        String string2 = string.trim().toLowerCase();
        if (BulldogUtil.isStringNumeric(string2)) {
            if (Double.parseDouble(string2) == 0.0) {
                return Low;
            }
            return High;
        }
        if (string2.equals("low")) {
            return Low;
        }
        if (string2.equals("high")) {
            return High;
        }
        throw new IllegalArgumentException(string2 + " is not a valid value for a signal");
    }

    public Signal inverse() {
        return this == High ? Low : High;
    }
}

