/*
 * Decompiled with CFR 0.152.
 */
package io.sevcik.hypherator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.sevcik.hypherator.HyphenDict;
import io.sevcik.hypherator.HyphenDictBuilder;
import io.sevcik.hypherator.HyphenationIterator;
import io.sevcik.hypherator.HyphenationIteratorImpl;
import io.sevcik.hypherator.dto.DictionaryEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hypherator {
    private static final Logger logger = LoggerFactory.getLogger(Hypherator.class);
    private static final String ALL_JSON_PATH = "/hyphen/all.json";
    private static final Map<String, HyphenDict> dictionaries = new HashMap<String, HyphenDict>();

    protected Hypherator() throws IOException {
        Hypherator.loadDictionaries();
    }

    public static HyphenationIterator getInstance(String locale) {
        HyphenDict dict = dictionaries.get(locale = locale.replace('_', '-'));
        if (dict == null) {
            return null;
        }
        return new HyphenationIteratorImpl(dict);
    }

    public static HyphenationIterator getInstance(InputStream inputStream) throws IOException {
        HyphenDict dict = HyphenDictBuilder.fromInputStream(inputStream);
        return new HyphenationIteratorImpl(dict);
    }

    protected static void loadDictionaries() throws IOException {
        try (InputStream is = Hypherator.class.getResourceAsStream(ALL_JSON_PATH);){
            if (is == null) {
                throw new IOException("Resource not found: /hyphen/all.json");
            }
            ObjectMapper objectMapper = new ObjectMapper();
            List entries = (List)objectMapper.readValue(is, (TypeReference)new TypeReference<List<DictionaryEntry>>(){});
            int dictionaryCount = 0;
            int localeCount = 0;
            for (DictionaryEntry entry : entries) {
                if (entry.getLocations() == null || entry.getLocations().isEmpty() || entry.getLocales() == null || entry.getLocales().isEmpty()) continue;
                String location = entry.getLocations().get(0);
                String resourcePath = "/hyphen/" + location;
                try {
                    logger.info("Loading dictionary: {} {}", (Object)resourcePath, entry.getLocales());
                    HyphenDict dict = Hypherator.loadDictionaryFromResource(resourcePath);
                    ++dictionaryCount;
                    for (String locale : entry.getLocales()) {
                        dictionaries.put(locale, dict);
                        ++localeCount;
                    }
                }
                catch (IOException e) {
                    logger.warn("Failed to load dictionary: {}", (Object)resourcePath, (Object)e);
                }
            }
            logger.info("Loaded {} dictionaries for {} locales", (Object)dictionaryCount, (Object)localeCount);
        }
    }

    protected static HyphenDict loadDictionaryFromResource(String resourcePath) throws IOException {
        try (InputStream is = Hypherator.class.getResourceAsStream(resourcePath);){
            if (is == null) {
                throw new IOException("Resource not found: " + resourcePath);
            }
            HyphenDict hyphenDict = HyphenDictBuilder.fromInputStream(is);
            return hyphenDict;
        }
    }

    protected Map<String, HyphenDict> getDictionaries() {
        return dictionaries;
    }

    protected HyphenDict getDictionary(String locale) {
        return dictionaries.get(locale);
    }

    static {
        try {
            Hypherator.loadDictionaries();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

