/*
 * Decompiled with CFR 0.152.
 */
package io.sevcik.hypherator;

import io.sevcik.hypherator.HyphenDict;
import io.sevcik.hypherator.Hyphenate;
import io.sevcik.hypherator.HyphenateImpl;
import io.sevcik.hypherator.HyphenationIterator;
import io.sevcik.hypherator.PotentialBreakImpl;
import io.sevcik.hypherator.dto.Pair;
import io.sevcik.hypherator.dto.PotentialBreak;
import java.util.List;

public class HyphenationIteratorImpl
implements HyphenationIterator {
    private String word = null;
    private int priorityFilter = 1;
    private final HyphenDict dict;
    private final Hyphenate hyphenate;
    private List<PotentialBreak> breaks = null;
    private int index = -1;

    protected HyphenationIteratorImpl(HyphenDict dict) {
        this.dict = dict;
        this.hyphenate = new HyphenateImpl();
    }

    @Override
    public void setUrgency(int urgency) {
        this.priorityFilter = 10 - urgency;
        this.resetState();
    }

    @Override
    public void setWord(String word) {
        this.word = word;
        this.breaks = this.hyphenate.hyphenate(this.dict, word);
        this.resetState();
    }

    @Override
    public PotentialBreak first() {
        if (this.word == null) {
            throw new IllegalStateException("No word has been set");
        }
        this.index = 0;
        while (this.index < this.breaks.size() && ((PotentialBreakImpl)this.breaks.get(this.index)).priority() < this.priorityFilter) {
            ++this.index;
        }
        if (this.index < this.breaks.size()) {
            return this.breaks.get(this.index);
        }
        return HyphenationIterator.DONE;
    }

    @Override
    public PotentialBreak next() {
        if (this.index == -1) {
            throw new IllegalStateException("Iterator not initialized with first()");
        }
        if (this.word == null) {
            throw new IllegalStateException("No word has been set");
        }
        ++this.index;
        while (this.index < this.breaks.size() && ((PotentialBreakImpl)this.breaks.get(this.index)).priority() < this.priorityFilter) {
            ++this.index;
        }
        if (this.index < this.breaks.size()) {
            return this.breaks.get(this.index);
        }
        return HyphenationIterator.DONE;
    }

    @Override
    public Pair<String, String> applyBreak(PotentialBreak breakRule) {
        return this.hyphenate.applyBreak(this.word, breakRule);
    }

    @Override
    public HyphenationIterator getInstanceOnRightPart(PotentialBreak breakRule) {
        if (this.breaks == null) {
            throw new IllegalStateException("No word has been set");
        }
        if (breakRule == null) {
            throw new IllegalArgumentException("Break rule cannot be null");
        }
        Pair<String, String> parts = this.hyphenate.applyBreak(this.word, breakRule);
        List<PotentialBreak> newPotentialBreaksList = this.hyphenate.getFurtherHyphenations(this.dict, this.breaks, breakRule, parts.getSecond());
        HyphenationIteratorImpl newIterator = new HyphenationIteratorImpl(this.dict);
        newIterator.priorityFilter = this.priorityFilter;
        newIterator.word = parts.getSecond();
        newIterator.breaks = newPotentialBreaksList;
        newIterator.index = -1;
        return newIterator;
    }

    private void resetState() {
        this.index = -1;
    }
}

