/*
 * Decompiled with CFR 0.152.
 */
package io.sevcik.hypherator;

import io.sevcik.hypherator.HyphenDict;
import io.sevcik.hypherator.Hyphenate;
import io.sevcik.hypherator.PotentialBreakImpl;
import io.sevcik.hypherator.dto.Pair;
import io.sevcik.hypherator.dto.PotentialBreak;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class HyphenateImpl
implements Hyphenate {
    public static final int DEFAULT_HYPHEN_MIN = 2;

    HyphenateImpl() {
    }

    @Override
    public Pair<String, String> applyBreak(String text, PotentialBreak breakRule) {
        PotentialBreakImpl breakRuleImpl = (PotentialBreakImpl)breakRule;
        if (breakRuleImpl.breakRule().replacement != null) {
            int replacementStart = breakRuleImpl.position() + breakRuleImpl.breakRule().replacementIndex - 1;
            String substituedText = text.substring(0, replacementStart) + breakRuleImpl.breakRule().replacement + text.substring(replacementStart + breakRuleImpl.breakRule().replacementCount);
            return new Pair<String, String>(substituedText.substring(0, substituedText.indexOf("=")), substituedText.substring(substituedText.indexOf("=") + 1));
        }
        return new Pair<String, String>(text.substring(0, breakRuleImpl.position()), text.substring(breakRuleImpl.position()));
    }

    @Override
    public List<PotentialBreak> getFurtherHyphenations(HyphenDict dict, List<PotentialBreak> currentBreaks, PotentialBreak breakPosition, String rightPart) {
        ArrayList<PotentialBreak> result = new ArrayList<PotentialBreak>();
        PotentialBreakImpl breakPositionImpl = (PotentialBreakImpl)breakPosition;
        for (PotentialBreak potentialBreak : currentBreaks) {
            PotentialBreakImpl potentialBreakImpl = (PotentialBreakImpl)potentialBreak;
            if (potentialBreakImpl.position() <= breakPositionImpl.position() + dict.leftHyphenMin) continue;
            result.add(new PotentialBreakImpl(potentialBreakImpl.position() - breakPositionImpl.position(), potentialBreakImpl.priority(), potentialBreakImpl.breakRule()));
        }
        this.cleanBreaksAtEdges(dict, rightPart, result);
        return result;
    }

    @Override
    public List<PotentialBreak> hyphenate(HyphenDict dict, String text) {
        List<PotentialBreak> possibleBreaks = this.applyStandardRules(dict, text, true, true);
        this.applyNohyphenRules(dict, text, possibleBreaks);
        this.cleanBreaksAtEdges(dict, text, possibleBreaks);
        return possibleBreaks;
    }

    private void cleanBreaksAtEdges(HyphenDict dict, String text, List<PotentialBreak> possibleBreaks) {
        int i;
        int digitsFromLeft;
        int digitsFromRight = 0;
        for (digitsFromLeft = 0; digitsFromLeft < text.length() && text.charAt(digitsFromLeft) >= '0' && text.charAt(digitsFromLeft) <= '9'; ++digitsFromLeft) {
        }
        while (digitsFromRight < text.length() && text.charAt(text.length() - 1 - digitsFromRight) >= '0' && text.charAt(text.length() - 1 - digitsFromRight) <= '9') {
            ++digitsFromRight;
        }
        int leftHyphenMin = dict.leftHyphenMin > 0 ? dict.leftHyphenMin : 2;
        int rightHyphenMin = dict.rightHyphenMin > 0 ? dict.rightHyphenMin : 2;
        int ligaturesFromLeft = 0;
        int ligaturesFromRight = 0;
        for (i = 0; i < Math.min(leftHyphenMin, text.length()); ++i) {
            if (text.charAt(i) < '\ufb00' || text.charAt(i) > '\ufb06') continue;
            ++ligaturesFromLeft;
            if (text.charAt(i) != '\ufb03' && text.charAt(i) != '\ufb04') continue;
            ++ligaturesFromLeft;
        }
        for (i = Math.max(text.length() - rightHyphenMin, 0); i < text.length(); ++i) {
            if (text.charAt(i) < '\ufb00' || text.charAt(i) > '\ufb06') continue;
            ++ligaturesFromRight;
            if (text.charAt(i) != '\ufb03' && text.charAt(i) != '\ufb04') continue;
            ++ligaturesFromRight;
        }
        int skipFromLeft = digitsFromLeft - ligaturesFromLeft;
        int skipFromRight = digitsFromRight - ligaturesFromRight;
        possibleBreaks.removeIf(breakRule -> ((PotentialBreakImpl)breakRule).position() < leftHyphenMin + skipFromLeft || ((PotentialBreakImpl)breakRule).position() > text.length() - rightHyphenMin - skipFromRight);
    }

    private void applyNohyphenRules(HyphenDict dict, String text, List<PotentialBreak> possibleBreaks) {
        for (String noHyphen : dict.noHyphens) {
            int index = text.indexOf(noHyphen);
            while (index >= 0) {
                int start = index;
                int end = index + noHyphen.length();
                possibleBreaks.removeIf(pb -> ((PotentialBreakImpl)pb).position() == start || ((PotentialBreakImpl)pb).position() == end);
                index = text.indexOf(noHyphen, index + 1);
            }
        }
    }

    private List<PotentialBreak> applyStandardRules(HyphenDict dict, String text, boolean isWordLeftEnd, boolean isWordRightEnd) {
        int i;
        text = "." + ((String)text).replaceAll("\\d", ".") + ".";
        Pair[] potentialBreaks = new Pair[((String)text).length()];
        for (int i2 = 0; i2 < potentialBreaks.length; ++i2) {
            potentialBreaks[i2] = new Pair<Integer, Object>(0, null);
        }
        this.applyRulesFromDict(dict, (String)text, potentialBreaks);
        if (dict.nextLevel != null) {
            int lastBreakPosition = 1;
            for (i = 2; i <= potentialBreaks.length - 1; ++i) {
                if (i == potentialBreaks.length - 1 && lastBreakPosition == 1) {
                    List<PotentialBreak> newBreaks = this.applyStandardRules(dict.nextLevel, ((String)text).substring(1, ((String)text).length() - 1), isWordLeftEnd, isWordRightEnd);
                    this.mergeBreakList(newBreaks, lastBreakPosition, potentialBreaks);
                    this.applyBorderRules(potentialBreaks, dict.leftCompoundMin, dict.rightCompoundMin, isWordLeftEnd, isWordRightEnd);
                    continue;
                }
                if ((Integer)potentialBreaks[i].getFirst() % 2 != 1 && i != potentialBreaks.length - 1) continue;
                HyphenDict.BreakRule potentialBreak = (HyphenDict.BreakRule)potentialBreaks[i].getSecond();
                HyphenDict.BreakRule previousBreak = (HyphenDict.BreakRule)potentialBreaks[lastBreakPosition].getSecond();
                String segment = ((String)text).substring(lastBreakPosition, i);
                segment = this.applyReplacementToSegment(segment, previousBreak, potentialBreak);
                int segmentOffsetAfterReplacement = 0;
                if (previousBreak != null && previousBreak.replacement != null) {
                    String replacementRight = previousBreak.replacement.substring(previousBreak.replacement.indexOf("=") + 1);
                    segmentOffsetAfterReplacement = previousBreak.replacementIndex + previousBreak.replacementCount - 1 - replacementRight.length();
                }
                List<PotentialBreak> newBreaks = this.applyStandardRules(dict, segment, i == 1 && isWordLeftEnd, i == potentialBreaks.length - 1 && isWordRightEnd);
                this.mergeBreakList(newBreaks, lastBreakPosition + segmentOffsetAfterReplacement, potentialBreaks);
                lastBreakPosition = i;
            }
        }
        ArrayList<PotentialBreak> result = new ArrayList<PotentialBreak>();
        for (i = 1; i < potentialBreaks.length; ++i) {
            if ((Integer)potentialBreaks[i].getFirst() % 2 != 1) continue;
            result.add(new PotentialBreakImpl(i - 1, (Integer)potentialBreaks[i].getFirst(), (HyphenDict.BreakRule)potentialBreaks[i].getSecond()));
        }
        return result;
    }

    private String applyReplacementToSegment(String segment, HyphenDict.BreakRule breakLeft, HyphenDict.BreakRule breakRight) {
        if (breakLeft != null && breakLeft.replacement != null) {
            segment = breakLeft.replacement.substring(breakLeft.replacement.indexOf("=") + 1) + ((String)segment).substring(breakLeft.replacementIndex + breakLeft.replacementCount - 1);
        }
        if (breakRight != null && breakRight.replacement != null) {
            int replacementStart = ((String)segment).length() - 1 + breakRight.replacementIndex;
            segment = ((String)segment).substring(0, replacementStart) + breakRight.replacement.substring(0, breakRight.replacement.indexOf("="));
        }
        return segment;
    }

    private void mergeBreakList(List<PotentialBreak> newBreaks, int offset, Pair<Integer, HyphenDict.BreakRule>[] potentialBreaks) {
        for (PotentialBreak newBreak : newBreaks) {
            int newBreakPosition = ((PotentialBreakImpl)newBreak).position() + offset;
            potentialBreaks[newBreakPosition].setFirst(((PotentialBreakImpl)newBreak).priority());
            potentialBreaks[newBreakPosition].setSecond(((PotentialBreakImpl)newBreak).breakRule());
        }
    }

    private void applyRulesFromDict(HyphenDict dict, String text, Pair<Integer, HyphenDict.BreakRule>[] breakCandidates) {
        int textLength = text.length();
        for (int start = 0; start < textLength - 1; ++start) {
            for (int end = start + 1; end <= textLength; ++end) {
                String toMatch = text.substring(start, end).toLowerCase();
                if (!dict.rules.containsKey(toMatch)) continue;
                for (Map.Entry<Integer, HyphenDict.BreakRule> breakRuleEntry : dict.rules.get(toMatch).getBreakRules().entrySet()) {
                    int breakPosition = start + breakRuleEntry.getKey();
                    int priority = breakRuleEntry.getValue().getValue();
                    if (priority <= breakCandidates[breakPosition].getFirst()) continue;
                    breakCandidates[breakPosition].setFirst(priority);
                    breakCandidates[breakPosition].setSecond(breakRuleEntry.getValue());
                }
            }
        }
    }

    private void applyBorderRules(Pair<Integer, HyphenDict.BreakRule>[] potentialBreaks, int leftHyphenMin, int rightHyphenMin, boolean isWordLeftEnd, boolean isWordRightEnd) {
        int i;
        if (!isWordLeftEnd) {
            for (i = 0; i <= leftHyphenMin; ++i) {
                potentialBreaks[i].setFirst(0);
                potentialBreaks[i].setSecond(null);
            }
        }
        if (!isWordRightEnd) {
            for (i = potentialBreaks.length - rightHyphenMin; i < potentialBreaks.length; ++i) {
                potentialBreaks[i].setFirst(0);
                potentialBreaks[i].setSecond(null);
            }
        }
    }
}

