/*
 * Decompiled with CFR 0.152.
 */
package io.sevcik.hypherator;

import io.sevcik.hypherator.HyphenDict;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HyphenDictBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HyphenDictBuilder.class);
    private static final List<String> DEFAULT_NO_HYPHEN_LIST = Arrays.stream("',\u2013,\u2019,-".split(",")).toList();

    HyphenDictBuilder() {
    }

    public static HyphenDict fromFile(String filename) throws IOException {
        HyphenDict hyphenDict;
        block8: {
            Path filePath = Paths.get(filename, new String[0]);
            InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);
            try {
                hyphenDict = HyphenDictBuilder.fromInputStream(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error reading file: " + filename, (Throwable)e);
                    throw e;
                }
            }
            inputStream.close();
        }
        return hyphenDict;
    }

    public static HyphenDict fromInputStream(InputStream inputStream) throws IOException {
        HyphenDict hyphenDict;
        logger.info("Loading hyphenation dictionary from input stream");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            HyphenDict dict;
            HyphenDict workingDict = dict = new HyphenDict();
            int level = 0;
            String line = reader.readLine();
            if (!"UTF8".equalsIgnoreCase(line) && !"UTF-8".equalsIgnoreCase(line)) {
                throw new RuntimeException("UTF-8 encoding expected");
            }
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("%") || line.startsWith("#") || line.trim().isEmpty()) continue;
                if (line.startsWith("LEFTHYPHENMIN")) {
                    workingDict.leftHyphenMin = Integer.parseInt(line.substring("LEFTHYPHENMIN".length()).trim());
                    continue;
                }
                if (line.startsWith("RIGHTHYPHENMIN")) {
                    workingDict.rightHyphenMin = Integer.parseInt(line.substring("RIGHTHYPHENMIN".length()).trim());
                    continue;
                }
                if (line.startsWith("COMPOUNDLEFTHYPHENMIN")) {
                    workingDict.leftCompoundMin = Integer.parseInt(line.substring("COMPOUNDLEFTHYPHENMIN".length()).trim());
                    continue;
                }
                if (line.startsWith("COMPOUNDRIGHTHYPHENMIN")) {
                    workingDict.rightCompoundMin = Integer.parseInt(line.substring("COMPOUNDRIGHTHYPHENMIN".length()).trim());
                    continue;
                }
                if (line.startsWith("NOHYPHEN")) {
                    List<String> noHphenList = Arrays.stream(line.substring("NOHYPHEN".length()).trim().split(",")).toList();
                    for (String noHphen : noHphenList) {
                        workingDict.insertNoHyphen(noHphen);
                    }
                    continue;
                }
                if (line.startsWith("NEXTLEVEL")) {
                    ++level;
                    workingDict = workingDict.nextLevel = new HyphenDict();
                    continue;
                }
                try {
                    HyphenDictBuilder.addNormalRule(workingDict, line);
                }
                catch (RuntimeException e) {
                    logger.error("Error reading input rule for rule {}", (Object)line, (Object)e);
                }
            }
            if (level == 0) {
                HyphenDict baseLevel = new HyphenDict();
                baseLevel.leftHyphenMin = dict.leftHyphenMin;
                baseLevel.rightHyphenMin = dict.rightHyphenMin;
                baseLevel.leftCompoundMin = dict.leftCompoundMin > 0 ? dict.leftCompoundMin : (dict.leftHyphenMin > 0 ? dict.leftHyphenMin : 3);
                baseLevel.rightCompoundMin = dict.rightCompoundMin > 0 ? dict.rightCompoundMin : (dict.rightHyphenMin > 0 ? dict.rightHyphenMin : 3);
                for (String noHphen : DEFAULT_NO_HYPHEN_LIST) {
                    baseLevel.insertNoHyphen(noHphen);
                }
                HyphenDictBuilder.addNormalRule(baseLevel, "1-1");
                HyphenDictBuilder.addNormalRule(baseLevel, "1'1");
                HyphenDictBuilder.addNormalRule(baseLevel, "1\u20131");
                HyphenDictBuilder.addNormalRule(baseLevel, "1\u20191");
                baseLevel.nextLevel = dict;
                dict = baseLevel;
            }
            hyphenDict = dict;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("Error reading input stream", (Throwable)e);
                throw e;
            }
        }
        reader.close();
        return hyphenDict;
    }

    public static void addNormalRule(HyphenDict dict, String line) {
        logger.debug("Adding rule {}", (Object)line);
        if (".mas5sz\u00e1z8s3zok1ni/sz=3,1,1,14".equals(line)) {
            logger.info("Replacing broken rule: {}", (Object)line);
            line = ".mas5sz\u00e1z8s3zok1ni/sz=,3,1";
        }
        if ("gic5csetek/cs=,3,1 ,1,9".equals(line)) {
            logger.info("Replacing broken rule: {}", (Object)line);
            line = "gic5csetek/cs=,3,1";
        }
        HyphenDict.Rule rule = new HyphenDict.Rule();
        String replRule = null;
        if (line.contains("/")) {
            replRule = line.substring(line.indexOf("/") + 1);
            line = line.substring(0, line.indexOf("/"));
        }
        StringBuilder word = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            if (Character.isDigit(line.charAt(i))) {
                int value = Character.getNumericValue(line.charAt(i));
                rule.getBreakRules().put(word.length(), new HyphenDict.BreakRule().setValue(value));
                continue;
            }
            word.append(line.charAt(i));
        }
        rule.setMatch(word.toString());
        if (replRule != null) {
            String[] replData = replRule.split(",");
            if (replData.length == 3) {
                String replacement = replData[0];
                int replacementIndex = Integer.parseInt(replData[1]);
                int replacementCount = Integer.parseInt(replData[2]);
                HyphenDict.BreakRule relevantBreak = null;
                if (rule.getMatch().startsWith(".")) {
                    ++replacementIndex;
                }
                for (int i = replacementIndex - 1; i < replacementIndex + replacementCount; ++i) {
                    HyphenDict.BreakRule potentialBreak = rule.getBreakRules().get(i);
                    if (potentialBreak == null) continue;
                    if (relevantBreak != null) {
                        throw new RuntimeException("CHECKPOINT - Multiple break rules within the same replacement region");
                    }
                    relevantBreak = potentialBreak;
                    replacementIndex -= i;
                }
                relevantBreak.setReplacement(replacement);
                relevantBreak.setReplacementIndex(replacementIndex);
                relevantBreak.setReplacementCount(replacementCount);
            } else if (replData.length == 1) {
                String replacement = replData[0];
                int replacementIndex = 1;
                int replacementCount = rule.getMatch().length();
                HyphenDict.BreakRule relevantBreak = rule.getBreakRules().get(replacementIndex);
                relevantBreak.setReplacement(replacement);
                relevantBreak.setReplacementIndex(replacementIndex);
                relevantBreak.setReplacementCount(replacementCount);
            } else {
                throw new RuntimeException("CHECKPOINT - WE DO HANDLE replacements without indices and counts");
            }
        }
        dict.insertRule(rule);
    }
}

