/*
 * Decompiled with CFR 0.152.
 */
package io.sevcik.hypherator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class HyphenDict {
    protected Integer leftHyphenMin = 0;
    protected Integer rightHyphenMin = 0;
    protected Integer leftCompoundMin = 0;
    protected Integer rightCompoundMin = 0;
    protected Map<String, Rule> rules = new HashMap<String, Rule>();
    protected HyphenDict nextLevel = null;
    protected List<String> noHyphens = new ArrayList<String>();

    HyphenDict() {
    }

    protected void insertRule(Rule newRule) {
        String key = newRule.match;
        if (this.rules.containsKey(key)) {
            Rule existingRule = this.rules.get(key);
            for (Map.Entry<Integer, BreakRule> newBreakRule : newRule.breakRules.entrySet()) {
                BreakRule existingBreakRule = existingRule.getBreakRules().get(newBreakRule.getKey());
                if (existingBreakRule != null) {
                    if (existingBreakRule.equals(newBreakRule.getValue())) continue;
                    int oldPriority = existingBreakRule.getValue();
                    int newPriority = newBreakRule.getValue().getValue();
                    if (newPriority <= oldPriority) continue;
                    existingRule.breakRules.put(newBreakRule.getKey(), newBreakRule.getValue());
                    continue;
                }
                existingRule.breakRules.put(newBreakRule.getKey(), newBreakRule.getValue());
            }
        } else {
            this.rules.put(key, newRule);
        }
    }

    protected void insertNoHyphen(String noHyphen) {
        this.noHyphens.add(noHyphen);
    }

    public static class Rule {
        String match;
        Map<Integer, BreakRule> breakRules = new HashMap<Integer, BreakRule>();

        public String getMatch() {
            return this.match;
        }

        public Rule setMatch(String match) {
            this.match = match;
            return this;
        }

        public Map<Integer, BreakRule> getBreakRules() {
            return this.breakRules;
        }
    }

    public static class BreakRule {
        int value;
        String replacement = null;
        int replacementIndex = 0;
        int replacementCount = 0;

        public int getValue() {
            return this.value;
        }

        public BreakRule setValue(int value) {
            this.value = value;
            return this;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public BreakRule setReplacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        public int getReplacementIndex() {
            return this.replacementIndex;
        }

        public BreakRule setReplacementIndex(int replacementIndex) {
            this.replacementIndex = replacementIndex;
            return this;
        }

        public int getReplacementCount() {
            return this.replacementCount;
        }

        public BreakRule setReplacementCount(int replCount) {
            this.replacementCount = replCount;
            return this;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BreakRule)) {
                return false;
            }
            BreakRule breakRule = (BreakRule)o;
            return this.value == breakRule.value && this.replacementIndex == breakRule.replacementIndex && this.replacementCount == breakRule.replacementCount && Objects.equals(this.replacement, breakRule.replacement);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.replacement, this.replacementIndex, this.replacementCount);
        }
    }
}

