/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.loadbalancer;

import io.sermant.core.common.LoggerFactory;
import io.sermant.core.plugin.service.PluginService;
import io.sermant.core.utils.StringUtils;
import io.sermant.loadbalancer.common.SafeConstructor;
import io.sermant.loadbalancer.rule.LoadbalancerRule;
import io.sermant.loadbalancer.service.RuleConverter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public class YamlRuleConverter
implements RuleConverter,
PluginService {
    private static final Logger LOGGER = LoggerFactory.getLogger();
    private final Yaml yaml;

    public YamlRuleConverter() {
        Representer representer = new Representer(new DumperOptions());
        representer.getPropertyUtils().setSkipMissingProperties(true);
        ArrayList<String> whiteList = new ArrayList<String>();
        whiteList.add(LoadbalancerRule.class.getCanonicalName());
        this.yaml = new Yaml(new SafeConstructor(whiteList), representer);
    }

    public <T> Optional<T> convert(String rawContent, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)rawContent)) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.yaml.loadAs(rawContent, clazz));
        }
        catch (YAMLException ex) {
            LOGGER.log(Level.WARNING, String.format(Locale.ENGLISH, "Can not convert content [%s] to LoadbalancerRule", rawContent), ex);
            return Optional.empty();
        }
    }
}

