/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.windows;

import io.sermant.flowcontrol.res4j.windows.WindowsBucket;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Stream;

public enum WindowsArray {
    INSTANCE;

    private static final int DEFAULT_WINDOWS_SIZE = 60;
    private static AtomicReferenceArray<WindowsBucket> windowsArray;

    public void initWindowsArray() {
        windowsArray = new AtomicReferenceArray(60);
        Stream.iterate(0, num -> num + 1).limit(60L).forEach(index -> windowsArray.set((int)index, new WindowsBucket()));
    }

    public WindowsBucket getCurrentWindow() {
        return windowsArray.get(this.calculateCurrentWindowsIndex());
    }

    public WindowsBucket getPreviousWindow() {
        return windowsArray.get(this.calculatePreviousWindowsIndex());
    }

    public WindowsBucket getWindow(int index) {
        return windowsArray.get(index);
    }

    public long getThreadNum() {
        return this.getCurrentWindow().threadNum.sum();
    }

    public void addSuccess(long startTime) {
        WindowsArray.windowsArray.get((int)this.calculateWindowsIndex((long)startTime)).success.increment();
    }

    public void addRt(long startTime, long responseTime) {
        WindowsArray.windowsArray.get((int)this.calculateWindowsIndex((long)startTime)).rt.add(responseTime);
    }

    public void addThreadNum(long startTime) {
        WindowsArray.windowsArray.get((int)this.calculateWindowsIndex((long)startTime)).threadNum.increment();
    }

    public void decreaseThreadNum(long startTime) {
        WindowsArray.windowsArray.get((int)this.calculateWindowsIndex((long)startTime)).threadNum.decrement();
    }

    public int calculateCurrentWindowsIndex() {
        return Calendar.getInstance().get(13) % 60;
    }

    public void resetNextWindows() {
        WindowsBucket windowsBucket = this.getWindow(this.calculateNextWindowsIndex());
        windowsBucket.success.reset();
        windowsBucket.rt.reset();
        windowsBucket.threadNum.reset();
    }

    public int calculateNextWindowsIndex() {
        int nextIndex = this.calculateCurrentWindowsIndex() + 1;
        if (nextIndex >= 60) {
            nextIndex = 0;
        }
        return nextIndex;
    }

    public int calculateWindowsIndex(long startTime) {
        if (System.currentTimeMillis() - startTime > 60000L) {
            return -1;
        }
        return (int)(startTime / 1000L % 60L);
    }

    public int calculatePreviousWindowsIndex() {
        int previousIndex = this.calculateCurrentWindowsIndex() - 1;
        if (previousIndex < 0) {
            previousIndex = 59;
        }
        return previousIndex;
    }

    public AtomicReferenceArray<WindowsBucket> getWindowsArray() {
        return windowsArray;
    }

    static {
        windowsArray = null;
    }
}

