/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.windows;

import com.sun.management.OperatingSystemMXBean;
import io.sermant.flowcontrol.res4j.windows.SystemStatus;
import io.sermant.flowcontrol.res4j.windows.WindowsArray;
import io.sermant.flowcontrol.res4j.windows.WindowsBucket;
import java.lang.management.ManagementFactory;
import java.util.TimerTask;

public class SystemStatusTask
extends TimerTask {
    private final SystemStatus systemStatus = SystemStatus.getInstance();

    @Override
    public void run() {
        if (WindowsArray.INSTANCE.calculateCurrentWindowsIndex() == 0) {
            this.initMinRtAndMaxThreadNum();
        }
        OperatingSystemMXBean operatingSystemMxBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        this.systemStatus.setCurrentLoad(operatingSystemMxBean.getSystemLoadAverage());
        this.systemStatus.setCurrentCpuUsage(operatingSystemMxBean.getSystemCpuLoad());
        this.updateMinRtAndMaxThreadNum();
        this.updateQpsAndAveRt();
        WindowsArray.INSTANCE.resetNextWindows();
    }

    private boolean checkBucket(WindowsBucket windowsBucket) {
        return windowsBucket != null && windowsBucket.success.sum() != 0L && windowsBucket.rt.sum() != 0L;
    }

    private void initMinRtAndMaxThreadNum() {
        this.systemStatus.setMinRt(Double.MAX_VALUE);
        this.systemStatus.setMaxThreadNum(Long.MIN_VALUE);
    }

    private void updateMinRtAndMaxThreadNum() {
        WindowsBucket windowsBucket = WindowsArray.INSTANCE.getCurrentWindow();
        long successNum = windowsBucket.success.sum();
        double rt = windowsBucket.rt.sum();
        double threadNum = windowsBucket.threadNum.sum();
        if (0L != successNum) {
            this.systemStatus.setMinRt(Math.min(this.systemStatus.getMinRt(), rt / (double)successNum));
        }
        this.systemStatus.setMaxThreadNum((long)Math.max((double)this.systemStatus.getMaxThreadNum(), threadNum + (double)successNum));
    }

    private void updateQpsAndAveRt() {
        long currentMillis;
        WindowsBucket previousWindowsBucket = WindowsArray.INSTANCE.getPreviousWindow();
        if (this.checkBucket(previousWindowsBucket)) {
            this.systemStatus.setQps(previousWindowsBucket.success.sum());
            this.systemStatus.setAveRt((double)previousWindowsBucket.rt.sum() / this.systemStatus.getQps());
            return;
        }
        WindowsBucket currentWindowsBucket = WindowsArray.INSTANCE.getCurrentWindow();
        if (this.checkBucket(currentWindowsBucket) && (currentMillis = System.currentTimeMillis() % 1000L) != 0L) {
            this.systemStatus.setQps(1000.0 * (double)currentWindowsBucket.success.sum() / (double)currentMillis);
            this.systemStatus.setAveRt((double)currentWindowsBucket.rt.sum() / (double)currentWindowsBucket.success.sum());
        }
    }
}

