/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.sermant.core.common.LoggerFactory;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Logger;

public class SerializeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger();
    private static final ObjectMapper MAPPER = new MessageMapper();

    private SerializeUtils() {
    }

    public static Optional<String> serialize2String(Object obj) {
        if (obj == null) {
            return Optional.of("");
        }
        try {
            return Optional.of(MAPPER.writeValueAsString(obj));
        }
        catch (JsonProcessingException ex) {
            LOGGER.warning(String.format(Locale.ENGLISH, "Can not serialize class [%s] to string", obj.getClass().getName()));
            return Optional.of("");
        }
    }

    static class MessageMapper
    extends ObjectMapper {
        MessageMapper() {
            this.getFactory().disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            this.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.without(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
            this._serializationConfig = (SerializationConfig)this._serializationConfig.without(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
            this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            this.enable(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS);
            this.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        }
    }
}

