/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.util;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.sermant.flowcontrol.common.entity.FlowControlResult;
import io.sermant.flowcontrol.res4j.exceptions.InstanceIsolationException;
import io.sermant.flowcontrol.res4j.handler.exception.ExceptionHandlerManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FlowControlExceptionUtils {
    private static final Set<Class<?>> RELEASE_FLOW_CONTROL_EXCEPTIONS = new HashSet<Class>(Arrays.asList(RequestNotPermitted.class, CallNotPermittedException.class, InstanceIsolationException.class));
    private static final ExceptionHandlerManager EXCEPTION_HANDLER_MANAGER = new ExceptionHandlerManager();

    private FlowControlExceptionUtils() {
    }

    public static void handleException(Throwable throwable, FlowControlResult result) {
        EXCEPTION_HANDLER_MANAGER.apply(throwable, result);
    }

    public static boolean isNeedReleasePermit(Throwable throwable) {
        for (Class<?> clazz : RELEASE_FLOW_CONTROL_EXCEPTIONS) {
            if (!clazz.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }
}

