/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.service;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import io.sermant.core.plugin.service.PluginService;
import io.sermant.core.utils.StringUtils;
import io.sermant.flowcontrol.common.entity.MetricEntity;
import io.sermant.flowcontrol.common.enums.MetricType;
import io.sermant.flowcontrol.res4j.util.MonitorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ServiceCollectorService
extends Collector
implements PluginService {
    public static final Map<String, CircuitBreaker> CIRCUIT_BREAKER_MAP = new ConcurrentHashMap<String, CircuitBreaker>();
    public static final Map<String, MetricEntity> MONITORS = new ConcurrentHashMap<String, MetricEntity>();
    private static final List<String> DEFAULT_LABEL_NAME = Collections.singletonList("name");
    private static final double DOUBLE_COMPARE_VALUE = 1.0E-8;
    private static Map<String, MetricEntity> lastMetricMap = new ConcurrentHashMap<String, MetricEntity>();
    private static Long lastStartTime;
    private static final int PROPORTION = 1000;

    public void start() {
        if (MonitorUtils.isStartMonitor()) {
            this.register();
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        HashMap<String, GaugeMetricFamily> metricMap = new HashMap<String, GaugeMetricFamily>();
        this.collectCircuitBreakerMetric(metricMap);
        ArrayList<Collector.MetricFamilySamples> samples = new ArrayList<Collector.MetricFamilySamples>();
        if (MONITORS.isEmpty()) {
            samples.addAll(metricMap.values());
            return samples;
        }
        Map<String, MetricEntity> currentMap = this.getCurrentMap();
        currentMap.forEach((key, value) -> {
            if (value == null || StringUtils.isBlank((CharSequence)value.getName())) {
                return;
            }
            this.collectFuseMetric((Map<String, GaugeMetricFamily>)metricMap, (String)key, (MetricEntity)value);
        });
        lastStartTime = System.currentTimeMillis();
        lastMetricMap = currentMap;
        samples.addAll(metricMap.values());
        return samples;
    }

    private void collectFuseMetric(Map<String, GaugeMetricFamily> metricMap, String metricLabel, MetricEntity metricInfo) {
        MetricEntity lastMetric = lastMetricMap.get(metricLabel) == null ? new MetricEntity() : lastMetricMap.get(metricLabel);
        long total = metricInfo.getFuseRequest().get() - lastMetric.getFuseRequest().get();
        this.addMetric(metricMap, MetricType.FUSED_REQUEST, total, metricLabel);
        long failure = metricInfo.getFailedClientRequest().get() - lastMetric.getFailedClientRequest().get();
        long ignore = metricInfo.getIgnoreFulFuseRequest().get() - lastMetric.getIgnoreFulFuseRequest().get();
        this.addMetric(metricMap, MetricType.FAILURE_FUSE_REQUEST, failure + ignore, metricLabel);
        double failRate = total == 0L ? 0.0 : (double)(failure + ignore) / (double)total;
        this.addMetric(metricMap, MetricType.FAILURE_RATE_FUSE_REQUEST, failRate, metricLabel);
        long fuseTime = metricInfo.getFuseTime().get() - lastMetric.getFuseTime().get();
        double avgResponseTime = total == 0L ? 0.0 : (double)fuseTime / (double)total;
        this.addMetric(metricMap, MetricType.AVG_RESPONSE_TIME, avgResponseTime, metricLabel);
        if (lastStartTime == null) {
            this.addMetric(metricMap, MetricType.QPS, 0.0, metricLabel);
            this.addMetric(metricMap, MetricType.TPS, 0.0, metricLabel);
        } else {
            long interval = System.currentTimeMillis() - lastStartTime;
            double qps = interval == 0L ? 0.0 : (double)(total * 1000L) / (double)interval;
            double tps = Math.abs(avgResponseTime) < 1.0E-8 ? 0.0 : qps * 1000.0 / avgResponseTime;
            this.addMetric(metricMap, MetricType.QPS, qps, metricLabel);
            this.addMetric(metricMap, MetricType.TPS, tps, metricLabel);
        }
        long slowNum = metricInfo.getSlowFuseRequest().get() - lastMetric.getSlowFuseRequest().get();
        this.addMetric(metricMap, MetricType.SLOW_CALL_NUMBER, slowNum, metricLabel);
        long permitted = metricInfo.getPermittedFulFuseRequest().get() - lastMetric.getPermittedFulFuseRequest().get();
        this.addMetric(metricMap, MetricType.PERMITTED_FUSE_REQUEST, permitted, metricLabel);
    }

    private void collectCircuitBreakerMetric(Map<String, GaugeMetricFamily> metricMap) {
        if (!CIRCUIT_BREAKER_MAP.isEmpty()) {
            CIRCUIT_BREAKER_MAP.forEach((key, circuitBreaker) -> {
                if (circuitBreaker == null) {
                    return;
                }
                CircuitBreaker.Metrics metrics = circuitBreaker.getMetrics();
                this.addMetric(metricMap, MetricType.FAILURE_RATE, metrics.getFailureRate(), (String)key);
                this.addMetric(metricMap, MetricType.SLOW_CALL_RATE, metrics.getSlowCallRate(), (String)key);
                this.addMetric(metricMap, MetricType.SLOW_CALL_NUMBER, metrics.getNumberOfSlowCalls(), (String)key);
                this.addMetric(metricMap, MetricType.BUFFERED_CALLS_NUMBER, metrics.getNumberOfBufferedCalls(), (String)key);
                this.addMetric(metricMap, MetricType.FAILED_CALLS_NUMBER, metrics.getNumberOfFailedCalls(), (String)key);
                this.addMetric(metricMap, MetricType.SLOW_CALL_FAILURE_NUMBER, metrics.getNumberOfSlowFailedCalls(), (String)key);
                this.addMetric(metricMap, MetricType.SUCCESSFUL_CALLS_NUMBER, metrics.getNumberOfSuccessfulCalls(), (String)key);
                this.addMetric(metricMap, MetricType.NOT_PERMITTED_CALLS_NUMBER, metrics.getNumberOfNotPermittedCalls(), (String)key);
                this.addMetric(metricMap, MetricType.SLOW_CALL_SUCCESS_NUMBER, metrics.getNumberOfSlowSuccessfulCalls(), (String)key);
            });
        }
    }

    private GaugeMetricFamily buildGaugeMetric(MetricType metricType) {
        return new GaugeMetricFamily(metricType.getName(), metricType.getDesc(), DEFAULT_LABEL_NAME);
    }

    private void addMetric(Map<String, GaugeMetricFamily> metricMap, MetricType type, double value, String labelValue) {
        GaugeMetricFamily metric = metricMap.computeIfAbsent(type.getName(), key -> this.buildGaugeMetric(type));
        metric.addMetric(Collections.singletonList(labelValue), value < 0.0 ? 0.0 : value);
    }

    private Map<String, MetricEntity> getCurrentMap() {
        ConcurrentHashMap<String, MetricEntity> target = new ConcurrentHashMap<String, MetricEntity>();
        if (!MONITORS.isEmpty()) {
            for (Map.Entry<String, MetricEntity> entry : MONITORS.entrySet()) {
                MetricEntity metricEntity = new MetricEntity();
                MetricEntity sourceMetric = entry.getValue();
                this.copy(metricEntity, sourceMetric);
                target.put(entry.getKey(), metricEntity);
            }
        }
        return target;
    }

    private void copy(MetricEntity metricEntity, MetricEntity sourceMetric) {
        if (sourceMetric == null) {
            return;
        }
        metricEntity.setName(sourceMetric.getName());
        this.copyValue(sourceMetric.getServerRequest(), metricEntity.getServerRequest());
        this.copyValue(sourceMetric.getClientRequest(), metricEntity.getClientRequest());
        this.copyValue(sourceMetric.getConsumeClientTime(), metricEntity.getConsumeClientTime());
        this.copyValue(sourceMetric.getConsumeServerTime(), metricEntity.getConsumeServerTime());
        this.copyValue(sourceMetric.getSuccessServerRequest(), metricEntity.getSuccessServerRequest());
        this.copyValue(sourceMetric.getSuccessClientRequest(), metricEntity.getSuccessClientRequest());
        this.copyValue(sourceMetric.getFailedServerRequest(), metricEntity.getFailedServerRequest());
        this.copyValue(sourceMetric.getFailedClientRequest(), metricEntity.getFailedClientRequest());
        this.copyValue(sourceMetric.getLastTime(), metricEntity.getLastTime());
        this.copyValue(sourceMetric.getFuseTime(), metricEntity.getFuseTime());
        this.copyValue(sourceMetric.getFailedFuseRequest(), metricEntity.getFailedFuseRequest());
        this.copyValue(sourceMetric.getSuccessFulFuseRequest(), metricEntity.getSuccessFulFuseRequest());
        this.copyValue(sourceMetric.getPermittedFulFuseRequest(), metricEntity.getPermittedFulFuseRequest());
        this.copyValue(sourceMetric.getIgnoreFulFuseRequest(), metricEntity.getIgnoreFulFuseRequest());
        this.copyValue(sourceMetric.getSlowFuseRequest(), metricEntity.getSlowFuseRequest());
        this.copyValue(sourceMetric.getFuseRequest(), metricEntity.getFuseRequest());
        metricEntity.setReportTime(sourceMetric.getReportTime());
    }

    private void copyValue(AtomicLong source, AtomicLong target) {
        if (source != null) {
            target.set(source.get());
        }
    }
}

