/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.handler.exception;

import io.sermant.core.service.xds.entity.XdsHeader;
import io.sermant.core.service.xds.entity.XdsHeaderOption;
import io.sermant.core.utils.StringUtils;
import io.sermant.flowcontrol.common.entity.FlowControlResponse;
import io.sermant.flowcontrol.common.entity.FlowControlResult;
import io.sermant.flowcontrol.res4j.exceptions.RateLimitException;
import io.sermant.flowcontrol.res4j.handler.exception.AbstractExceptionHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class XdsRateLimitingExceptionHandler
extends AbstractExceptionHandler<RateLimitException> {
    @Override
    protected FlowControlResponse getFlowControlResponse(RateLimitException ex, FlowControlResult flowControlResult) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (XdsHeaderOption xdsHeaderOption : ex.getXdsHeaderOptions()) {
            XdsHeader header = xdsHeaderOption.getHeader();
            if (header == null || StringUtils.isEmpty((CharSequence)header.getKey())) continue;
            if (xdsHeaderOption.isEnabledAppend() && headers.containsKey(header.getKey())) {
                List value = (List)headers.get(header.getKey());
                value.set(0, (String)value.get(0) + "," + header.getValue());
                continue;
            }
            headers.put(header.getKey(), Collections.singletonList(header.getValue()));
        }
        return new FlowControlResponse("Rate Limited", 429, headers, null);
    }

    @Override
    public Class<RateLimitException> targetException() {
        return RateLimitException.class;
    }
}

