/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.handler.exception;

import io.sermant.core.common.LoggerFactory;
import io.sermant.flowcontrol.common.entity.FlowControlResult;
import io.sermant.flowcontrol.res4j.chain.AbstractChainHandler;
import io.sermant.flowcontrol.res4j.handler.exception.ExceptionHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExceptionHandlerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger();
    private Map<Class<?>, ExceptionHandler<?>> handlers;

    public ExceptionHandlerManager() {
        this.loadHandlers();
    }

    public void apply(Throwable ex, FlowControlResult result) {
        ExceptionHandler<?> handler = this.handlers.get(ex.getClass());
        if (handler == null) {
            LOGGER.log(Level.WARNING, "Can not handler flow control exception!", ex);
            return;
        }
        handler.accept(ex, result);
    }

    private void loadHandlers() {
        HashMap map = new HashMap();
        for (ExceptionHandler handler : ServiceLoader.load(ExceptionHandler.class, AbstractChainHandler.class.getClassLoader())) {
            map.put(handler.targetException(), handler);
        }
        this.handlers = Collections.unmodifiableMap(map);
    }
}

