/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.handler.exception;

import io.sermant.flowcontrol.common.entity.FlowControlResponse;
import io.sermant.flowcontrol.common.entity.FlowControlResult;
import io.sermant.flowcontrol.res4j.handler.exception.ExceptionHandler;
import io.sermant.flowcontrol.res4j.util.SerializeUtils;
import java.util.Locale;
import java.util.Optional;

public abstract class AbstractExceptionHandler<E extends Throwable>
implements ExceptionHandler<E> {
    @Override
    public void accept(E ex, FlowControlResult flowControlResult) {
        FlowControlResponse response = this.getFlowControlResponse(ex, flowControlResult);
        if (response.isReplaceResult()) {
            Optional<String> serializeResult = SerializeUtils.serialize2String(response.getResult());
            if (serializeResult.isPresent()) {
                response.setSerializeResult(serializeResult.get());
            } else {
                response.setSerializeResult(String.format(Locale.ENGLISH, "Can not serialize target class [%s]", response.getResult() == null ? "null result" : response.getResult().getClass().getName()));
            }
        }
        flowControlResult.setResponse(response);
    }

    protected abstract FlowControlResponse getFlowControlResponse(E var1, FlowControlResult var2);
}

