/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.handler;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.sermant.flowcontrol.common.core.rule.RateLimitingRule;
import io.sermant.flowcontrol.common.handler.AbstractRequestHandler;
import java.time.Duration;
import java.util.Optional;

public class RateLimitingHandler
extends AbstractRequestHandler<RateLimiter, RateLimitingRule> {
    protected final Optional<RateLimiter> createHandler(String businessName, RateLimitingRule rule) {
        RateLimiterConfig config = RateLimiterConfig.custom().limitForPeriod(rule.getRate()).limitRefreshPeriod(Duration.ofMillis(rule.getParsedLimitRefreshPeriod())).timeoutDuration(Duration.ofMillis(rule.getParsedTimeoutDuration())).build();
        RateLimiterRegistry rateLimiterRegistry = RateLimiterRegistry.of(config);
        return Optional.of(rateLimiterRegistry.rateLimiter(businessName));
    }

    protected final String configKey() {
        return "servicecomb.rateLimiting";
    }
}

