/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.handler;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.sermant.flowcontrol.common.core.rule.CircuitBreakerRule;
import io.sermant.flowcontrol.common.entity.MetricEntity;
import io.sermant.flowcontrol.common.handler.AbstractRequestHandler;
import io.sermant.flowcontrol.common.util.StringUtils;
import io.sermant.flowcontrol.res4j.adaptor.CircuitBreakerAdaptor;
import io.sermant.flowcontrol.res4j.service.ServiceCollectorService;
import io.sermant.flowcontrol.res4j.util.MonitorUtils;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

public class CircuitBreakerHandler
extends AbstractRequestHandler<CircuitBreaker, CircuitBreakerRule> {
    protected final Optional<CircuitBreaker> createHandler(String businessName, CircuitBreakerRule rule) {
        CircuitBreakerConfig.SlidingWindowType slidingWindowType = this.getSlidingWindowType(rule.getSlidingWindowType());
        CircuitBreaker circuitBreaker = CircuitBreakerRegistry.of(CircuitBreakerConfig.custom().failureRateThreshold(rule.getFailureRateThreshold()).slowCallRateThreshold(rule.getSlowCallRateThreshold()).waitDurationInOpenState(Duration.ofMillis(rule.getParsedWaitDurationInOpenState())).slowCallDurationThreshold(Duration.ofMillis(rule.getParsedSlowCallDurationThreshold())).permittedNumberOfCallsInHalfOpenState(rule.getPermittedNumberOfCallsInHalfOpenState()).minimumNumberOfCalls(rule.getMinimumNumberOfCalls()).slidingWindowType(slidingWindowType).slidingWindowSize(this.getWindowSize(slidingWindowType, rule.getParsedSlidingWindowSize())).build()).circuitBreaker(businessName);
        if (MonitorUtils.isStartMonitor()) {
            CircuitBreakerHandler.addEventConsumers(circuitBreaker);
            ServiceCollectorService.CIRCUIT_BREAKER_MAP.putIfAbsent(businessName, circuitBreaker);
        }
        return Optional.of(new CircuitBreakerAdaptor(circuitBreaker, rule));
    }

    private static void addEventConsumers(CircuitBreaker circuitBreaker) {
        Map<String, MetricEntity> monitors = ServiceCollectorService.MONITORS;
        MetricEntity metricEntity = monitors.computeIfAbsent(circuitBreaker.getName(), str -> new MetricEntity());
        metricEntity.setName(circuitBreaker.getName());
        circuitBreaker.getEventPublisher().onError(event -> {
            metricEntity.getFailedFuseRequest().getAndIncrement();
            metricEntity.getFuseRequest().getAndIncrement();
            metricEntity.getFuseTime().getAndAdd(event.getElapsedDuration().toMillis());
        }).onSuccess(event -> {
            metricEntity.getFuseRequest().getAndIncrement();
            metricEntity.getSuccessFulFuseRequest().getAndIncrement();
            metricEntity.getFuseTime().getAndAdd(event.getElapsedDuration().toMillis());
        }).onCallNotPermitted(event -> metricEntity.getPermittedFulFuseRequest().getAndIncrement()).onIgnoredError(event -> {
            metricEntity.getIgnoreFulFuseRequest().getAndIncrement();
            metricEntity.getFuseRequest().getAndIncrement();
            metricEntity.getFuseTime().getAndAdd(event.getElapsedDuration().toMillis());
        }).onSlowCallRateExceeded(event -> metricEntity.getSlowFuseRequest().getAndIncrement());
    }

    private int getWindowSize(CircuitBreakerConfig.SlidingWindowType slidingWindowType, long parsedSlidingWindowSize) {
        if (slidingWindowType == CircuitBreakerConfig.SlidingWindowType.COUNT_BASED) {
            return (int)parsedSlidingWindowSize;
        }
        return (int)Duration.ofMillis(parsedSlidingWindowSize).getSeconds();
    }

    private CircuitBreakerConfig.SlidingWindowType getSlidingWindowType(String type) {
        if (StringUtils.equalIgnoreCase((String)type, (String)"count")) {
            return CircuitBreakerConfig.SlidingWindowType.COUNT_BASED;
        }
        return CircuitBreakerConfig.SlidingWindowType.TIME_BASED;
    }

    protected String configKey() {
        return "servicecomb.circuitBreaker";
    }
}

