/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.handler;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.sermant.flowcontrol.common.core.rule.BulkheadRule;
import io.sermant.flowcontrol.common.handler.AbstractRequestHandler;
import java.time.Duration;
import java.util.Optional;

public class BulkheadHandler
extends AbstractRequestHandler<Bulkhead, BulkheadRule> {
    protected final Optional<Bulkhead> createHandler(String businessName, BulkheadRule rule) {
        BulkheadConfig config = BulkheadConfig.custom().maxConcurrentCalls(rule.getMaxConcurrentCalls()).maxWaitDuration(Duration.ofMillis(rule.getParsedMaxWaitDuration())).build();
        return Optional.of(BulkheadRegistry.of(config).bulkhead(businessName));
    }

    protected final String configKey() {
        return "servicecomb.bulkhead";
    }
}

