/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.exceptions;

import io.sermant.flowcontrol.common.core.rule.SystemRule;
import io.sermant.flowcontrol.common.core.rule.fault.Fault;
import io.sermant.flowcontrol.res4j.exceptions.SystemRuleException;
import io.sermant.flowcontrol.res4j.util.SystemRuleUtils;

public class SystemRuleFault
implements Fault {
    private SystemRule rule;

    public SystemRuleFault(SystemRule systemRule) {
        this.rule = systemRule;
    }

    public void acquirePermission() {
        if (SystemRuleUtils.getQps() > this.rule.getQps()) {
            throw new SystemRuleException("Trigger qps flow control", this.rule);
        }
        if (SystemRuleUtils.getThreadNum() > this.rule.getThreadNum()) {
            throw new SystemRuleException("Trigger threadNum flow control", this.rule);
        }
        if (SystemRuleUtils.getAveRt() > (double)this.rule.getAveRt()) {
            throw new SystemRuleException("Trigger rt flow control", this.rule);
        }
        if (SystemRuleUtils.getCurrentLoad() > this.rule.getSystemLoad() && (!SystemRuleUtils.isEnableSystemAdaptive() || this.checkHistoryData())) {
            throw new SystemRuleException("Trigger load flow control", this.rule);
        }
        if (SystemRuleUtils.getCurrentCpuUsage() > this.rule.getCpuUsage()) {
            throw new SystemRuleException("Trigger cpu flow control", this.rule);
        }
    }

    private boolean checkHistoryData() {
        long threadNum = SystemRuleUtils.getThreadNum();
        return threadNum > 1L && (double)threadNum > SystemRuleUtils.getMaxThreadNum() * SystemRuleUtils.getMinRt() / 1000.0;
    }
}

