/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.exceptions;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.sermant.flowcontrol.res4j.adaptor.CircuitBreakerAdaptor;
import java.util.Locale;

public class CircuitBreakerException
extends RuntimeException {
    private final CircuitBreaker circuitBreaker;

    public CircuitBreakerException(CircuitBreaker circuitBreaker, String message, boolean writableStackTrace) {
        super(message, null, false, writableStackTrace);
        this.circuitBreaker = circuitBreaker;
    }

    public static CircuitBreakerException createException(CircuitBreaker circuitBreaker) {
        return new CircuitBreakerException(circuitBreaker, CircuitBreakerException.createMsg(circuitBreaker), circuitBreaker.getCircuitBreakerConfig().isWritableStackTraceEnabled());
    }

    protected static String createMsg(CircuitBreaker circuitBreaker) {
        String msg = circuitBreaker instanceof CircuitBreakerAdaptor && ((CircuitBreakerAdaptor)circuitBreaker).isForceOpen() ? String.format(Locale.ENGLISH, "CircuitBreaker '%s' has forced open and deny any requests", circuitBreaker.getName()) : String.format(Locale.ENGLISH, "CircuitBreaker '%s' is %s and does not permit further calls", new Object[]{circuitBreaker.getName(), circuitBreaker.getState()});
        return msg;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }
}

