/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain.handler;

import io.sermant.core.service.xds.entity.FractionalPercent;
import io.sermant.core.service.xds.entity.XdsRateLimit;
import io.sermant.core.service.xds.entity.XdsTokenBucket;
import io.sermant.core.utils.StringUtils;
import io.sermant.flowcontrol.common.entity.FlowControlScenario;
import io.sermant.flowcontrol.common.entity.RequestEntity;
import io.sermant.flowcontrol.common.util.RandomUtil;
import io.sermant.flowcontrol.common.xds.handler.XdsHandler;
import io.sermant.flowcontrol.common.xds.ratelimit.XdsRateLimitManager;
import io.sermant.flowcontrol.res4j.chain.AbstractXdsChainHandler;
import io.sermant.flowcontrol.res4j.exceptions.RateLimitException;
import java.util.Optional;

public class XdsRateLimitRequestHandler
extends AbstractXdsChainHandler {
    @Override
    public void onBefore(RequestEntity requestEntity, FlowControlScenario scenarioInfo) {
        this.handleRateLimit(scenarioInfo);
        super.onBefore(requestEntity, scenarioInfo);
    }

    private void handleRateLimit(FlowControlScenario scenarioInfo) {
        Optional xdsRateLimitOptional = XdsHandler.INSTANCE.getRateLimit(scenarioInfo.getServiceName(), scenarioInfo.getRouteName(), scenarioInfo.getClusterName());
        if (!xdsRateLimitOptional.isPresent()) {
            return;
        }
        XdsRateLimit xdsRateLimit = (XdsRateLimit)xdsRateLimitOptional.get();
        XdsTokenBucket tokenBucket = xdsRateLimit.getTokenBucket();
        if (tokenBucket == null || xdsRateLimit.getPercent() == null || tokenBucket.getMaxTokens() <= 0 || tokenBucket.getFillInterval() <= 0L) {
            return;
        }
        FractionalPercent fractionalPercent = xdsRateLimit.getPercent();
        if (fractionalPercent.getNumerator() <= 0 || fractionalPercent.getDenominator() <= 0) {
            return;
        }
        int randomNum = RandomUtil.randomInt((int)fractionalPercent.getDenominator());
        if (randomNum >= fractionalPercent.getNumerator()) {
            return;
        }
        if (!XdsRateLimitManager.fillAndConsumeToken((String)scenarioInfo.getServiceName(), (String)scenarioInfo.getRouteName(), (XdsTokenBucket)tokenBucket)) {
            throw new RateLimitException(xdsRateLimit.getResponseHeaderOption());
        }
    }

    @Override
    public void onThrow(RequestEntity requestEntity, FlowControlScenario scenarioInfo, Throwable throwable) {
        super.onThrow(requestEntity, scenarioInfo, throwable);
    }

    @Override
    public void onAfter(RequestEntity requestEntity, FlowControlScenario scenarioInfo, Object result) {
        super.onAfter(requestEntity, scenarioInfo, result);
    }

    @Override
    public int getOrder() {
        return 5000;
    }

    @Override
    protected boolean isSkip(RequestEntity requestEntity, FlowControlScenario scenarioInfo) {
        return scenarioInfo == null || StringUtils.isEmpty((CharSequence)scenarioInfo.getServiceName()) || StringUtils.isEmpty((CharSequence)scenarioInfo.getRouteName());
    }

    @Override
    protected RequestEntity.RequestType direct() {
        return RequestEntity.RequestType.SERVER;
    }
}

