/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain.handler;

import io.sermant.core.common.LoggerFactory;
import io.sermant.core.service.xds.entity.FractionalPercent;
import io.sermant.core.service.xds.entity.XdsAbort;
import io.sermant.core.service.xds.entity.XdsDelay;
import io.sermant.core.service.xds.entity.XdsHttpFault;
import io.sermant.core.utils.StringUtils;
import io.sermant.flowcontrol.common.core.rule.fault.FaultException;
import io.sermant.flowcontrol.common.entity.FlowControlScenario;
import io.sermant.flowcontrol.common.entity.RequestEntity;
import io.sermant.flowcontrol.common.util.RandomUtil;
import io.sermant.flowcontrol.common.xds.handler.XdsHandler;
import io.sermant.flowcontrol.res4j.chain.AbstractXdsChainHandler;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XdsFaultRequestHandler
extends AbstractXdsChainHandler {
    private static final String MESSAGE = "The request has been aborted due to triggering fault injection";
    private static final Logger LOGGER = LoggerFactory.getLogger();

    @Override
    public void onBefore(RequestEntity requestEntity, FlowControlScenario scenarioInfo) {
        Optional xdsHttpFaultOptional = XdsHandler.INSTANCE.getHttpFault(scenarioInfo.getServiceName(), scenarioInfo.getRouteName());
        if (!xdsHttpFaultOptional.isPresent()) {
            super.onBefore(requestEntity, scenarioInfo);
            return;
        }
        XdsHttpFault xdsHttpFault = (XdsHttpFault)xdsHttpFaultOptional.get();
        if (xdsHttpFault.getAbort() == null && xdsHttpFault.getDelay() == null) {
            super.onBefore(requestEntity, scenarioInfo);
            return;
        }
        this.executeAbort(xdsHttpFault.getAbort());
        this.executeDelay(xdsHttpFault.getDelay());
        super.onBefore(requestEntity, scenarioInfo);
    }

    private void executeAbort(XdsAbort xdsAbort) {
        if (xdsAbort.getPercentage() == null) {
            return;
        }
        FractionalPercent fractionalPercent = xdsAbort.getPercentage();
        if (fractionalPercent.getNumerator() <= 0 || fractionalPercent.getDenominator() <= 0) {
            return;
        }
        int randomNum = RandomUtil.randomInt((int)fractionalPercent.getDenominator());
        if (randomNum < fractionalPercent.getNumerator()) {
            int status = xdsAbort.getHttpStatus() > 0 ? xdsAbort.getHttpStatus() : 500;
            throw new FaultException(status, MESSAGE, null);
        }
    }

    private void executeDelay(XdsDelay delay) {
        if (delay.getFixedDelay() <= 0L || delay.getPercentage() == null) {
            return;
        }
        FractionalPercent fractionalPercent = delay.getPercentage();
        if (fractionalPercent.getNumerator() <= 0 || fractionalPercent.getDenominator() <= 0) {
            return;
        }
        int randomNum = RandomUtil.randomInt((int)fractionalPercent.getDenominator());
        if (randomNum >= fractionalPercent.getNumerator()) {
            return;
        }
        LOGGER.log(Level.FINE, "Start delay request by delay fault, delay time is {0}ms", delay.getFixedDelay());
        try {
            Thread.sleep(delay.getFixedDelay());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void onThrow(RequestEntity requestEntity, FlowControlScenario scenarioInfo, Throwable throwable) {
        super.onThrow(requestEntity, scenarioInfo, throwable);
    }

    @Override
    public void onAfter(RequestEntity requestEntity, FlowControlScenario scenarioInfo, Object result) {
        super.onAfter(requestEntity, scenarioInfo, result);
    }

    @Override
    protected boolean isSkip(RequestEntity requestEntity, FlowControlScenario scenarioInfo) {
        return scenarioInfo == null || StringUtils.isEmpty((CharSequence)scenarioInfo.getServiceName()) || StringUtils.isEmpty((CharSequence)scenarioInfo.getRouteName());
    }

    @Override
    protected RequestEntity.RequestType direct() {
        return RequestEntity.RequestType.CLIENT;
    }

    @Override
    public int getOrder() {
        return 3000;
    }
}

