/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain.handler;

import io.sermant.flowcontrol.common.core.rule.fault.Fault;
import io.sermant.flowcontrol.common.entity.FlowControlScenario;
import io.sermant.flowcontrol.common.entity.RequestEntity;
import io.sermant.flowcontrol.res4j.chain.context.RequestContext;
import io.sermant.flowcontrol.res4j.chain.handler.FlowControlHandler;
import io.sermant.flowcontrol.res4j.handler.SystemRuleHandler;
import io.sermant.flowcontrol.res4j.util.SystemRuleUtils;
import io.sermant.flowcontrol.res4j.windows.WindowsArray;
import java.util.List;

public class SystemServerReqHandler
extends FlowControlHandler<Fault> {
    private final SystemRuleHandler systemRuleHandler = new SystemRuleHandler();
    private final String contextName = SystemServerReqHandler.class.getName();

    @Override
    public void onBefore(RequestContext context, FlowControlScenario businessEntity) {
        if (SystemRuleUtils.isEnableSystemRule()) {
            List faults = this.systemRuleHandler.createOrGetHandlers(businessEntity.getMatchedScenarioNames());
            if (!faults.isEmpty()) {
                faults.forEach(Fault::acquirePermission);
            }
            context.save("requestStartTime", System.currentTimeMillis());
            WindowsArray.INSTANCE.addThreadNum(context.get("requestStartTime", Long.TYPE));
        }
        super.onBefore(context, businessEntity);
    }

    @Override
    public void onThrow(RequestContext context, FlowControlScenario scenarioInfo, Throwable throwable) {
        context.remove(this.getContextName());
        context.remove("requestStartTime");
        super.onThrow(context, scenarioInfo, throwable);
    }

    @Override
    public void onResult(RequestContext context, FlowControlScenario scenarioInfo, Object result) {
        if (SystemRuleUtils.isEnableSystemRule() && context.hasKey("requestStartTime")) {
            long startTime = context.get("requestStartTime", Long.TYPE);
            WindowsArray.INSTANCE.addSuccess(startTime);
            WindowsArray.INSTANCE.decreaseThreadNum(startTime);
            WindowsArray.INSTANCE.addRt(startTime, System.currentTimeMillis() - startTime);
            context.remove("requestStartTime");
        }
        context.remove(this.getContextName());
        super.onResult(context, scenarioInfo, result);
    }

    @Override
    protected RequestEntity.RequestType direct() {
        return RequestEntity.RequestType.SERVER;
    }

    @Override
    public int getOrder() {
        return 11000;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }
}

