/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain.handler;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.sermant.flowcontrol.common.entity.FlowControlScenario;
import io.sermant.flowcontrol.res4j.chain.context.RequestContext;
import io.sermant.flowcontrol.res4j.chain.handler.FlowControlHandler;
import io.sermant.flowcontrol.res4j.handler.RateLimitingHandler;
import java.util.List;

public class RateLimitingRequestHandler
extends FlowControlHandler<RateLimiter> {
    private final RateLimitingHandler rateLimitingHandler = new RateLimitingHandler();

    @Override
    public void onBefore(RequestContext context, FlowControlScenario scenarioInfo) {
        List handlers = this.rateLimitingHandler.createOrGetHandlers(scenarioInfo.getMatchedScenarioNames());
        if (!handlers.isEmpty()) {
            context.save(this.getContextName(), handlers);
            handlers.forEach(rateLimiter -> RateLimiter.waitForPermission(rateLimiter, 1));
        }
        super.onBefore(context, scenarioInfo);
    }

    @Override
    public void onThrow(RequestContext context, FlowControlScenario scenarioInfo, Throwable throwable) {
        List<RateLimiter> rateLimiters = this.getHandlersFromCache(context.getSourceName(), this.getContextName());
        if (rateLimiters != null) {
            rateLimiters.forEach(rateLimiter -> rateLimiter.onError(throwable));
        }
        super.onThrow(context, scenarioInfo, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResult(RequestContext context, FlowControlScenario scenarioInfo, Object result) {
        try {
            List<RateLimiter> rateLimiters = this.getHandlersFromCache(context.getSourceName(), this.getContextName());
            if (rateLimiters != null) {
                rateLimiters.forEach(rateLimiter -> rateLimiter.onResult(result));
            }
        }
        finally {
            context.remove(this.getContextName());
        }
        super.onResult(context, scenarioInfo, result);
    }

    @Override
    public int getOrder() {
        return 6000;
    }
}

