/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain.handler;

import io.sermant.flowcontrol.common.entity.FlowControlScenario;
import io.sermant.flowcontrol.common.entity.RequestEntity;
import io.sermant.flowcontrol.res4j.chain.context.RequestContext;
import io.sermant.flowcontrol.res4j.chain.handler.CircuitBreakerRequestHandler;
import io.sermant.flowcontrol.res4j.exceptions.CircuitBreakerException;
import io.sermant.flowcontrol.res4j.exceptions.InstanceIsolationException;
import io.sermant.flowcontrol.res4j.handler.CircuitBreakerHandler;
import io.sermant.flowcontrol.res4j.handler.InstanceIsolationHandler;

public class InstanceIsolationRequestHandler
extends CircuitBreakerRequestHandler {
    private static final String CONTEXT_NAME = InstanceIsolationRequestHandler.class.getName();
    private static final String START_TIME = CONTEXT_NAME + "_START_TIME";

    @Override
    public void onBefore(RequestContext context, FlowControlScenario flowControlScenario) {
        try {
            super.onBefore(context, flowControlScenario);
        }
        catch (CircuitBreakerException ex) {
            throw InstanceIsolationException.createException(ex.getCircuitBreaker());
        }
    }

    @Override
    protected RequestEntity.RequestType direct() {
        return RequestEntity.RequestType.CLIENT;
    }

    @Override
    protected CircuitBreakerHandler getHandler() {
        return new InstanceIsolationHandler();
    }

    @Override
    public int getOrder() {
        return 9000;
    }

    @Override
    protected String getContextName() {
        return CONTEXT_NAME;
    }

    @Override
    protected String getStartTime() {
        return START_TIME;
    }
}

