/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain.handler;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.sermant.core.utils.CollectionUtils;
import io.sermant.flowcontrol.common.entity.FlowControlScenario;
import io.sermant.flowcontrol.res4j.adaptor.CircuitBreakerAdaptor;
import io.sermant.flowcontrol.res4j.chain.context.RequestContext;
import io.sermant.flowcontrol.res4j.chain.handler.FlowControlHandler;
import io.sermant.flowcontrol.res4j.exceptions.CircuitBreakerException;
import io.sermant.flowcontrol.res4j.handler.CircuitBreakerHandler;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CircuitBreakerRequestHandler
extends FlowControlHandler<CircuitBreaker> {
    private static final String CONTEXT_NAME = CircuitBreakerRequestHandler.class.getName();
    private static final String START_TIME = CONTEXT_NAME + "_START_TIME";
    private final CircuitBreakerHandler circuitBreakerHandler = this.getHandler();

    @Override
    public void onBefore(RequestContext context, FlowControlScenario flowControlScenario) {
        List circuitBreakers = this.circuitBreakerHandler.createOrGetHandlers(flowControlScenario.getMatchedScenarioNames());
        if (!circuitBreakers.isEmpty()) {
            for (CircuitBreaker circuitBreaker : circuitBreakers) {
                this.checkForceOpen(circuitBreaker);
                this.checkCircuitBreakerState(circuitBreaker);
            }
            context.save(this.getStartTime(), ((CircuitBreaker)circuitBreakers.get(0)).getCurrentTimestamp());
            context.save(this.getContextName(), circuitBreakers);
        }
        super.onBefore(context, flowControlScenario);
    }

    private void checkCircuitBreakerState(CircuitBreaker circuitBreaker) {
        boolean isSuccess = circuitBreaker.tryAcquirePermission();
        if (!isSuccess) {
            throw CircuitBreakerException.createException(circuitBreaker);
        }
    }

    private void checkForceOpen(CircuitBreaker circuitBreaker) {
        if (circuitBreaker instanceof CircuitBreakerAdaptor && ((CircuitBreakerAdaptor)circuitBreaker).isForceOpen()) {
            throw CircuitBreakerException.createException(circuitBreaker);
        }
    }

    @Override
    public void onThrow(RequestContext context, FlowControlScenario scenario, Throwable throwable) {
        this.process(context, throwable, null, false);
        super.onThrow(context, scenario, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResult(RequestContext context, FlowControlScenario scenario, Object result) {
        try {
            this.process(context, null, result, true);
        }
        finally {
            context.remove(this.getContextName());
            context.remove(this.getStartTime());
        }
        super.onResult(context, scenario, result);
    }

    private void process(RequestContext context, Throwable throwable, Object result, boolean isResult) {
        Long startTime = context.get(this.getStartTime(), Long.class);
        List<CircuitBreaker> circuitBreakers = this.getHandlersFromCache(context.getSourceName(), this.getContextName());
        if (startTime == null || circuitBreakers == null || circuitBreakers.isEmpty()) {
            return;
        }
        long duration = ((CircuitBreaker)circuitBreakers.get(0)).getCurrentTimestamp() - startTime;
        TimeUnit timestampUnit = ((CircuitBreaker)circuitBreakers.get(0)).getTimestampUnit();
        if (throwable != null) {
            circuitBreakers.forEach(circuitBreaker -> circuitBreaker.onError(duration, timestampUnit, throwable));
        }
        if (isResult && context.get("__OCCURRED_REQUEST_EXCEPTION__", Throwable.class) == null) {
            circuitBreakers.forEach(circuitBreaker -> circuitBreaker.onResult(duration, timestampUnit, result));
        }
    }

    @Override
    protected boolean isSkip(RequestContext context, FlowControlScenario scenario) {
        return scenario == null || CollectionUtils.isEmpty((Collection)scenario.getMatchedScenarioNames()) || this.isForceClose(this.circuitBreakerHandler.createOrGetHandlers(scenario.getMatchedScenarioNames()));
    }

    private boolean isForceClose(List<CircuitBreaker> circuitBreakers) {
        for (CircuitBreaker circuitBreaker : circuitBreakers) {
            if (!(circuitBreaker instanceof CircuitBreakerAdaptor) || !((CircuitBreakerAdaptor)circuitBreaker).isForceClosed()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getContextName() {
        return CONTEXT_NAME;
    }

    protected String getStartTime() {
        return START_TIME;
    }

    @Override
    public int getOrder() {
        return 10000;
    }

    protected CircuitBreakerHandler getHandler() {
        return new CircuitBreakerHandler();
    }
}

