/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain.handler;

import io.sermant.core.utils.CollectionUtils;
import io.sermant.flowcontrol.common.core.match.MatchManager;
import io.sermant.flowcontrol.common.entity.FlowControlScenario;
import io.sermant.flowcontrol.res4j.chain.AbstractChainHandler;
import io.sermant.flowcontrol.res4j.chain.context.ChainContext;
import io.sermant.flowcontrol.res4j.chain.context.RequestContext;
import java.util.Collection;
import java.util.Set;

public class BusinessRequestHandler
extends AbstractChainHandler {
    private static final String MATCHED_SCENARIO_INFO = "__MATCHED_SCENARIO_INFO__";

    @Override
    public void onBefore(RequestContext context, FlowControlScenario flowControlScenario) {
        Set matchedBusinessNames = MatchManager.INSTANCE.matchWithCache(context.getRequestEntity());
        if (CollectionUtils.isEmpty((Collection)matchedBusinessNames)) {
            return;
        }
        FlowControlScenario scenarioInfo = new FlowControlScenario();
        scenarioInfo.setMatchedScenarioNames(matchedBusinessNames);
        context.save(MATCHED_SCENARIO_INFO, scenarioInfo);
        super.onBefore(context, scenarioInfo);
    }

    @Override
    public void onThrow(RequestContext context, FlowControlScenario flowControlScenario, Throwable throwable) {
        FlowControlScenario scenarioInfo = this.getMatchedScenarioInfo(context);
        if (scenarioInfo == null || CollectionUtils.isEmpty((Collection)scenarioInfo.getMatchedScenarioNames())) {
            return;
        }
        super.onThrow(context, scenarioInfo, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResult(RequestContext context, FlowControlScenario flowControlScenario, Object result) {
        FlowControlScenario scenarioInfo = this.getMatchedScenarioInfo(context);
        if (scenarioInfo == null || CollectionUtils.isEmpty((Collection)scenarioInfo.getMatchedScenarioNames())) {
            return;
        }
        try {
            super.onResult(context, scenarioInfo, result);
        }
        finally {
            ChainContext.getThreadLocalContext(context.getSourceName()).remove(MATCHED_SCENARIO_INFO);
        }
    }

    private FlowControlScenario getMatchedScenarioInfo(RequestContext context) {
        return context.get(MATCHED_SCENARIO_INFO, FlowControlScenario.class);
    }

    @Override
    public int getOrder() {
        return -1000;
    }
}

