/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain.handler;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.sermant.flowcontrol.common.entity.FlowControlScenario;
import io.sermant.flowcontrol.res4j.chain.context.ChainContext;
import io.sermant.flowcontrol.res4j.chain.context.RequestContext;
import io.sermant.flowcontrol.res4j.chain.handler.FlowControlHandler;
import io.sermant.flowcontrol.res4j.handler.BulkheadHandler;
import java.util.List;

public class BulkheadRequestHandler
extends FlowControlHandler<Bulkhead> {
    private final BulkheadHandler bulkheadHandler = new BulkheadHandler();

    @Override
    public void onBefore(RequestContext context, FlowControlScenario flowControlScenario) {
        List handlers = this.bulkheadHandler.createOrGetHandlers(flowControlScenario.getMatchedScenarioNames());
        if (!handlers.isEmpty()) {
            context.save(this.getContextName(), handlers);
            handlers.forEach(Bulkhead::acquirePermission);
        }
        super.onBefore(context, flowControlScenario);
    }

    @Override
    public void onThrow(RequestContext context, FlowControlScenario flowControlScenario, Throwable throwable) {
        super.onThrow(context, flowControlScenario, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResult(RequestContext context, FlowControlScenario flowControlScenario, Object result) {
        try {
            List<Bulkhead> bulkheads = this.getHandlersFromCache(context.getSourceName(), this.getContextName());
            if (bulkheads != null && !this.isOccurBulkheadLimit(context.getSourceName())) {
                bulkheads.forEach(Bulkhead::onComplete);
            }
        }
        finally {
            context.remove(this.getContextName());
        }
        super.onResult(context, flowControlScenario, result);
    }

    private boolean isOccurBulkheadLimit(String sourceName) {
        return ChainContext.getThreadLocalContext(sourceName).get("__OCCURRED_FLOW_EXCEPTION__", Exception.class) instanceof BulkheadFullException;
    }

    @Override
    public int getOrder() {
        return 7000;
    }
}

