/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain.context;

import io.sermant.core.common.LoggerFactory;
import io.sermant.flowcontrol.common.entity.RequestEntity;
import io.sermant.flowcontrol.res4j.chain.HandlerConstants;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class RequestContext {
    private static final Logger LOGGER = LoggerFactory.getLogger();
    private final Map<String, Object> localMap = new ConcurrentHashMap<String, Object>();
    private final ThreadLocal<Map<String, RequestContext>> threadLocal;
    private final String sourceName;
    private RequestEntity requestEntity;

    public RequestContext(ThreadLocal<Map<String, RequestContext>> threadLocal, String sourceName) {
        this.threadLocal = threadLocal;
        this.sourceName = sourceName;
    }

    public void save(String name, Object target) {
        if (name == null || target == null) {
            LOGGER.warning("ThreadLocal name or target can not be empty!");
            return;
        }
        this.localMap.put(this.formatKey(name), target);
    }

    public <T> T get(String name, Class<T> clazz) {
        return (T)this.localMap.get(this.formatKey(name));
    }

    public void remove(String name) {
        this.localMap.remove(this.formatKey(name));
        if (this.localMap.isEmpty()) {
            this.threadLocal.remove();
        }
    }

    public void clear() {
        this.localMap.clear();
    }

    private boolean isNeedFormat(String name) {
        return !HandlerConstants.THREAD_LOCAL_KEY_PREFIX.equals(name);
    }

    private String formatKey(String name) {
        if (!this.isNeedFormat(name)) {
            return name;
        }
        String keyPrefix = this.get(HandlerConstants.THREAD_LOCAL_KEY_PREFIX, String.class);
        if (keyPrefix == null) {
            return name;
        }
        return keyPrefix + name;
    }

    public RequestEntity getRequestEntity() {
        return this.requestEntity;
    }

    public void setRequestEntity(RequestEntity requestEntity) {
        this.requestEntity = requestEntity;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public boolean hasKey(String key) {
        return this.localMap.containsKey(key);
    }
}

