/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain.context;

import io.sermant.flowcontrol.res4j.chain.HandlerConstants;
import io.sermant.flowcontrol.res4j.chain.context.RequestContext;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ChainContext {
    private static final ThreadLocal<Map<String, RequestContext>> THREAD_LOCAL_CONTEXT_MAP = new ThreadLocal();
    private static final int MAX_SIZE = 11;

    private ChainContext() {
    }

    public static RequestContext getThreadLocalContext(String name) {
        Map<String, RequestContext> contextMap = THREAD_LOCAL_CONTEXT_MAP.get();
        if (contextMap == null) {
            contextMap = new ConcurrentHashMap<String, RequestContext>(11);
            THREAD_LOCAL_CONTEXT_MAP.set(contextMap);
        }
        if (contextMap.size() >= 11) {
            throw new IllegalArgumentException("Can not create context in current thread!");
        }
        return contextMap.computeIfAbsent(name, sourceName -> new RequestContext(THREAD_LOCAL_CONTEXT_MAP, (String)sourceName));
    }

    public static void remove() {
        Map<String, RequestContext> contextMap = THREAD_LOCAL_CONTEXT_MAP.get();
        if (contextMap != null) {
            contextMap.clear();
            THREAD_LOCAL_CONTEXT_MAP.remove();
        }
    }

    public static void remove(String name) {
        Map<String, RequestContext> contextMap = THREAD_LOCAL_CONTEXT_MAP.get();
        if (contextMap != null) {
            contextMap.remove(name);
            if (contextMap.isEmpty()) {
                THREAD_LOCAL_CONTEXT_MAP.remove();
            }
        }
    }

    public static void setKeyPrefix(String sourceName, String keyPrefix) {
        if (keyPrefix != null) {
            ChainContext.getThreadLocalContext(sourceName).save(HandlerConstants.THREAD_LOCAL_KEY_PREFIX, keyPrefix);
        }
    }

    public static Optional<String> getKeyPrefix(String sourceName) {
        return Optional.ofNullable(ChainContext.getThreadLocalContext(sourceName).get(HandlerConstants.THREAD_LOCAL_KEY_PREFIX, String.class));
    }
}

