/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain;

import io.sermant.core.common.LoggerFactory;
import io.sermant.flowcontrol.common.entity.FlowControlResult;
import io.sermant.flowcontrol.common.entity.FlowControlScenario;
import io.sermant.flowcontrol.common.entity.RequestEntity;
import io.sermant.flowcontrol.res4j.chain.HandlerChainBuilder;
import io.sermant.flowcontrol.res4j.chain.XdsHandlerChain;
import io.sermant.flowcontrol.res4j.util.FlowControlExceptionUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum XdsHandlerChainEntry {
    INSTANCE;

    private static final Logger LOGGER;
    private final XdsHandlerChain chain = HandlerChainBuilder.INSTANCE.buildXdsHandlerChain();

    public void onBefore(RequestEntity requestEntity, FlowControlResult flowControlResult) {
        try {
            this.chain.onBefore(requestEntity, null);
        }
        catch (Exception ex) {
            flowControlResult.setRequestType(requestEntity.getRequestType());
            FlowControlExceptionUtils.handleException(ex, flowControlResult);
            LOGGER.log(Level.FINE, ex, ex::getMessage);
        }
    }

    public void onAfter(RequestEntity requestEntity, Object result, FlowControlScenario flowControlScenario) {
        this.chain.onAfter(requestEntity, flowControlScenario, result);
    }

    public void onThrow(RequestEntity requestEntity, Throwable throwable, FlowControlScenario flowControlScenario) {
        this.chain.onThrow(requestEntity, flowControlScenario, throwable);
    }

    static {
        LOGGER = LoggerFactory.getLogger();
    }
}

