/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain;

import io.sermant.core.common.LoggerFactory;
import io.sermant.flowcontrol.common.entity.FlowControlResult;
import io.sermant.flowcontrol.common.entity.RequestEntity;
import io.sermant.flowcontrol.common.util.XdsThreadLocalUtil;
import io.sermant.flowcontrol.res4j.chain.HandlerChain;
import io.sermant.flowcontrol.res4j.chain.HandlerChainBuilder;
import io.sermant.flowcontrol.res4j.chain.context.ChainContext;
import io.sermant.flowcontrol.res4j.chain.context.RequestContext;
import io.sermant.flowcontrol.res4j.util.FlowControlExceptionUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum HandlerChainEntry {
    INSTANCE;

    private static final Logger LOGGER;
    private final HandlerChain chain = HandlerChainBuilder.INSTANCE.build();

    public void onBefore(String sourceName, RequestEntity requestEntity, FlowControlResult flowControlResult) {
        try {
            RequestContext threadLocalContext = ChainContext.getThreadLocalContext(sourceName);
            threadLocalContext.setRequestEntity(requestEntity);
            this.chain.onBefore(threadLocalContext, null);
        }
        catch (Exception ex) {
            flowControlResult.setRequestType(requestEntity.getRequestType());
            FlowControlExceptionUtils.handleException(ex, flowControlResult);
            ChainContext.getThreadLocalContext(sourceName).save("__OCCURRED_FLOW_EXCEPTION__", ex);
            LOGGER.log(Level.FINE, ex, ex::getMessage);
        }
    }

    public void onDubboBefore(String sourceName, RequestEntity requestEntity, FlowControlResult flowControlResult, boolean isProvider) {
        String formatSourceName = this.formatSourceName(sourceName, isProvider);
        this.configPrefix(formatSourceName, isProvider);
        this.onBefore(formatSourceName, requestEntity, flowControlResult);
    }

    private String formatSourceName(String sourceName, boolean isProvider) {
        String prefix = isProvider ? "PROVIDER:" : "CONSUMER:";
        StringBuilder sb = new StringBuilder(prefix.length() + sourceName.length());
        sb.append(prefix).append(sourceName);
        return sb.toString();
    }

    public void onResult(String sourceName, Object result) {
        try {
            this.chain.onResult(ChainContext.getThreadLocalContext(sourceName), XdsThreadLocalUtil.getScenarioInfo(), result);
        }
        finally {
            ChainContext.remove(sourceName);
        }
    }

    private void configPrefix(String sourceName, boolean isProvider) {
        if (isProvider) {
            ChainContext.setKeyPrefix(sourceName, "PROVIDER:");
        } else {
            ChainContext.setKeyPrefix(sourceName, "CONSUMER:");
        }
    }

    public void onDubboResult(String sourceName, Object result, boolean isProvider) {
        String formatSourceName = this.formatSourceName(sourceName, isProvider);
        this.configPrefix(formatSourceName, isProvider);
        this.onResult(formatSourceName, result);
    }

    public void onThrow(String sourceName, Throwable throwable) {
        RequestContext context = ChainContext.getThreadLocalContext(sourceName);
        context.save("__OCCURRED_REQUEST_EXCEPTION__", throwable);
        this.chain.onThrow(context, XdsThreadLocalUtil.getScenarioInfo(), throwable);
    }

    public void onDubboThrow(String sourceName, Throwable throwable, boolean isProvider) {
        String formatSourceName = this.formatSourceName(sourceName, isProvider);
        this.configPrefix(formatSourceName, isProvider);
        this.onThrow(formatSourceName, throwable);
    }

    static {
        LOGGER = LoggerFactory.getLogger();
    }
}

