/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain;

import io.sermant.flowcontrol.common.util.StringUtils;
import io.sermant.flowcontrol.res4j.chain.AbstractChainHandler;
import io.sermant.flowcontrol.res4j.chain.AbstractXdsChainHandler;
import io.sermant.flowcontrol.res4j.chain.HandlerChain;
import io.sermant.flowcontrol.res4j.chain.XdsHandlerChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

public enum HandlerChainBuilder {
    INSTANCE;

    private static final int HANDLER_SIZE = 4;
    private static final List<AbstractChainHandler> HANDLERS;
    private static final List<AbstractXdsChainHandler> XDS_HANDLERS;

    public HandlerChain build() {
        HandlerChain processorChain = new HandlerChain();
        Collections.sort(HANDLERS);
        HANDLERS.forEach(processorChain::addLastHandler);
        return processorChain;
    }

    public XdsHandlerChain buildXdsHandlerChain() {
        Collections.sort(XDS_HANDLERS);
        XdsHandlerChain xdsHandlerChain = new XdsHandlerChain();
        XDS_HANDLERS.forEach(xdsHandlerChain::addLastHandler);
        return xdsHandlerChain;
    }

    public static Optional<AbstractChainHandler> getHandler(String name) {
        for (AbstractChainHandler abstractChainHandler : HANDLERS) {
            if (!StringUtils.equal((String)abstractChainHandler.getClass().getName(), (String)name)) continue;
            return Optional.of(abstractChainHandler);
        }
        return Optional.empty();
    }

    static {
        HANDLERS = new ArrayList<AbstractChainHandler>(4);
        XDS_HANDLERS = new ArrayList<AbstractXdsChainHandler>(4);
        ClassLoader classLoader = HandlerChainBuilder.class.getClassLoader();
        for (AbstractChainHandler abstractChainHandler : ServiceLoader.load(AbstractChainHandler.class, classLoader)) {
            HANDLERS.add(abstractChainHandler);
        }
        for (AbstractXdsChainHandler abstractXdsChainHandler : ServiceLoader.load(AbstractXdsChainHandler.class, classLoader)) {
            XDS_HANDLERS.add(abstractXdsChainHandler);
        }
    }
}

