/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain;

import io.sermant.core.plugin.config.PluginConfigManager;
import io.sermant.flowcontrol.common.config.XdsFlowControlConfig;
import io.sermant.flowcontrol.common.entity.FlowControlScenario;
import io.sermant.flowcontrol.common.entity.RequestEntity;
import io.sermant.flowcontrol.res4j.chain.XdsRequestHandler;

public abstract class AbstractXdsChainHandler
implements XdsRequestHandler,
Comparable<AbstractXdsChainHandler> {
    protected static final XdsFlowControlConfig XDS_FLOW_CONTROL_CONFIG = (XdsFlowControlConfig)PluginConfigManager.getPluginConfig(XdsFlowControlConfig.class);
    private AbstractXdsChainHandler next;

    @Override
    public void onBefore(RequestEntity requestEntity, FlowControlScenario flowControlScenario) {
        AbstractXdsChainHandler cur = this.getNextHandler(requestEntity, flowControlScenario);
        if (cur != null) {
            cur.onBefore(requestEntity, flowControlScenario);
        }
    }

    @Override
    public void onThrow(RequestEntity requestEntity, FlowControlScenario flowControlScenario, Throwable throwable) {
        AbstractXdsChainHandler cur = this.getNextHandler(requestEntity, flowControlScenario);
        if (cur != null) {
            cur.onThrow(requestEntity, flowControlScenario, throwable);
        }
    }

    @Override
    public void onAfter(RequestEntity requestEntity, FlowControlScenario flowControlScenario, Object result) {
        AbstractXdsChainHandler cur = this.getNextHandler(requestEntity, flowControlScenario);
        if (cur != null) {
            cur.onAfter(requestEntity, flowControlScenario, result);
        }
    }

    private AbstractXdsChainHandler getNextHandler(RequestEntity entity, FlowControlScenario flowControlScenario) {
        AbstractXdsChainHandler handler;
        for (handler = this.next; handler != null && this.isNeedSkip(handler, entity, flowControlScenario); handler = handler.getNext()) {
        }
        return handler;
    }

    private boolean isNeedSkip(AbstractXdsChainHandler handler, RequestEntity requestEntity, FlowControlScenario scenario) {
        RequestEntity.RequestType direct = handler.direct();
        if (direct != RequestEntity.RequestType.BOTH && requestEntity.getRequestType() != direct) {
            return true;
        }
        return handler.isSkip(requestEntity, scenario);
    }

    protected RequestEntity.RequestType direct() {
        return RequestEntity.RequestType.BOTH;
    }

    protected boolean isSkip(RequestEntity requestEntity, FlowControlScenario flowControlScenario) {
        return !XDS_FLOW_CONTROL_CONFIG.isEnable();
    }

    @Override
    public int compareTo(AbstractXdsChainHandler handler) {
        return this.getOrder() - handler.getOrder();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setNext(AbstractXdsChainHandler handler) {
        this.next = handler;
    }

    public AbstractXdsChainHandler getNext() {
        return this.next;
    }
}

