/*
 * Decompiled with CFR 0.152.
 */
package io.sermant.flowcontrol.res4j.chain;

import io.sermant.core.plugin.config.PluginConfigManager;
import io.sermant.flowcontrol.common.config.XdsFlowControlConfig;
import io.sermant.flowcontrol.common.entity.FlowControlScenario;
import io.sermant.flowcontrol.common.entity.RequestEntity;
import io.sermant.flowcontrol.res4j.chain.RequestHandler;
import io.sermant.flowcontrol.res4j.chain.context.RequestContext;

public abstract class AbstractChainHandler
implements RequestHandler,
Comparable<AbstractChainHandler> {
    protected static final XdsFlowControlConfig XDS_FLOW_CONTROL_CONFIG = (XdsFlowControlConfig)PluginConfigManager.getPluginConfig(XdsFlowControlConfig.class);
    private AbstractChainHandler next;

    @Override
    public void onBefore(RequestContext context, FlowControlScenario flowControlScenario) {
        AbstractChainHandler cur = this.getNextHandler(context, flowControlScenario);
        if (cur != null) {
            cur.onBefore(context, flowControlScenario);
        }
    }

    @Override
    public void onThrow(RequestContext context, FlowControlScenario flowControlScenario, Throwable throwable) {
        AbstractChainHandler cur = this.getNextHandler(context, flowControlScenario);
        if (cur != null) {
            cur.onThrow(context, flowControlScenario, throwable);
        }
    }

    @Override
    public void onResult(RequestContext context, FlowControlScenario flowControlScenario, Object result) {
        AbstractChainHandler cur = this.getNextHandler(context, flowControlScenario);
        if (cur != null) {
            cur.onResult(context, flowControlScenario, result);
        }
    }

    private AbstractChainHandler getNextHandler(RequestContext context, FlowControlScenario flowControlScenario) {
        AbstractChainHandler tmp;
        for (tmp = this.next; tmp != null && this.isNeedSkip(tmp, context, flowControlScenario); tmp = tmp.getNext()) {
        }
        return tmp;
    }

    private boolean isNeedSkip(AbstractChainHandler tmp, RequestContext context, FlowControlScenario scenario) {
        RequestEntity.RequestType direct = tmp.direct();
        if (direct != RequestEntity.RequestType.BOTH && context.getRequestEntity() != null && context.getRequestEntity().getRequestType() != direct) {
            return true;
        }
        String skipKey = this.skipCacheKey(tmp);
        Boolean isSkip = context.get(skipKey, Boolean.class);
        if (isSkip == null) {
            isSkip = tmp.isSkip(context, scenario);
            context.save(skipKey, isSkip);
        }
        return isSkip;
    }

    private String skipCacheKey(AbstractChainHandler tmp) {
        String className = tmp.getClass().getName();
        RequestEntity.RequestType direct = tmp.direct();
        return direct + "_" + className + "_skip_flag";
    }

    protected RequestEntity.RequestType direct() {
        return RequestEntity.RequestType.BOTH;
    }

    protected boolean isSkip(RequestContext context, FlowControlScenario flowControlScenario) {
        return XDS_FLOW_CONTROL_CONFIG.isEnable();
    }

    @Override
    public int compareTo(AbstractChainHandler handler) {
        return this.getOrder() - handler.getOrder();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setNext(AbstractChainHandler processor) {
        this.next = processor;
    }

    public AbstractChainHandler getNext() {
        return this.next;
    }
}

